/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import org.eclipse.ecf.core.util.IClassResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassResolverObjectInputStream
extends ObjectInputStream {
    public static final HashMap<String, Class<?>> primClasses = new HashMap(8, 1.0f);
    private final BundleContext bundleContext;
    private ServiceTracker<IClassResolver, IClassResolver> classResolverST;

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }

    public static ObjectInputStream create(BundleContext ctxt, InputStream ins, String filter) throws IOException, SecurityException {
        if (ctxt == null) {
            return new ObjectInputStream(ins);
        }
        try {
            return new ClassResolverObjectInputStream(ctxt, ins, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IOException("Could not create ClassResolverObjectInputStream because of InvalidSyntaxException in filter=" + filter);
        }
    }

    public static ObjectInputStream create(BundleContext ctxt, InputStream ins) throws IOException {
        return ClassResolverObjectInputStream.create(ctxt, ins, "(org.eclipse.ecf.core.util.classresolver.bundleSymbolicName=" + ctxt.getBundle().getSymbolicName() + ")");
    }

    private Filter createClassResolverFilter(String classResolverFilterString) throws InvalidSyntaxException {
        String objectClassFilterString = "(objectClass=" + IClassResolver.class.getName() + ")";
        if (classResolverFilterString != null) {
            objectClassFilterString = "(&" + objectClassFilterString + classResolverFilterString + ")";
        }
        return this.bundleContext.createFilter(objectClassFilterString);
    }

    protected ClassResolverObjectInputStream(BundleContext ctxt, String classResolverFilter) throws IOException, SecurityException, InvalidSyntaxException {
        this.bundleContext = ctxt;
        this.classResolverST = new ServiceTracker(this.bundleContext, this.createClassResolverFilter(classResolverFilter), null);
    }

    protected ClassResolverObjectInputStream(BundleContext ctxt) throws IOException, SecurityException, InvalidSyntaxException {
        this(ctxt, (String)null);
    }

    public ClassResolverObjectInputStream(BundleContext ctxt, InputStream ins, String classResolverFilter) throws IOException, SecurityException, InvalidSyntaxException {
        super(ins);
        this.bundleContext = ctxt;
        this.classResolverST = new ServiceTracker(this.bundleContext, this.createClassResolverFilter(classResolverFilter), null);
    }

    public ClassResolverObjectInputStream(BundleContext ctxt, InputStream ins) throws IOException, SecurityException, InvalidSyntaxException {
        this(ctxt, ins, null);
    }

    protected BundleContext getContext() {
        return this.bundleContext;
    }

    private IClassResolver getClassResolver() {
        IClassResolver result = null;
        if (this.classResolverST != null) {
            this.classResolverST.open();
            result = (IClassResolver)this.classResolverST.getService();
            this.classResolverST.close();
        }
        return result;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        IClassResolver classResolver = null;
        if (this.classResolverST != null) {
            this.classResolverST.open();
            classResolver = (IClassResolver)this.classResolverST.getService();
            this.classResolverST.close();
        }
        if (classResolver != null) {
            return classResolver.resolveClass(desc);
        }
        throw new ClassNotFoundException("Cannot deserialize class=" + desc + " because no IClassResolver service available");
    }

    public static Class<?> resolvePrimitiveClass(ObjectStreamClass desc, ClassNotFoundException cnfe) throws ClassNotFoundException {
        Class<?> cl = primClasses.get(desc.getName());
        if (cl != null) {
            return cl;
        }
        if (cnfe != null) {
            throw cnfe;
        }
        throw new ClassNotFoundException("Could not find class=" + desc);
    }
}

