/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.service;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Module;
import java.util.List;
import org.apache.log4j.Logger;

public class CompoundModule
implements Module {
    private static Logger LOGGER = Logger.getLogger(CompoundModule.class);
    private List<Module> modules = Lists.newArrayList();

    public void configure(Binder binder) {
        for (Module module : this.modules) {
            try {
                module.configure(binder);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void add(Module module) {
        this.modules.add(module);
    }

    public void remove(Module module) {
        this.modules.remove(module);
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public int size() {
        return this.modules.size();
    }
}

