/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.navigator.wizards;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecp.common.MEClassLabelProvider;
import org.eclipse.emf.ecp.common.model.ECPMetaModelElementContext;
import org.eclipse.emf.ecp.common.model.ECPWorkspaceManager;
import org.eclipse.emf.ecp.common.model.NoWorkspaceException;
import org.eclipse.emf.ecp.navigator.Activator;
import org.eclipse.emf.ecp.navigator.wizards.ModelClassFilter;
import org.eclipse.emf.ecp.navigator.wizards.ModelTreeContentProvider;
import org.eclipse.emf.ecp.navigator.wizards.NewModelElementWizard;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class ModelTreePage
extends WizardPage
implements Listener {
    private TreeViewer treeViewer;
    private static final String PAGE_TITLE = "Add new model element";
    private static final String PAGE_DESCRIPTION = "Select model element type";
    private final EClass selected;

    protected ModelTreePage(String pageName, EClass selected) {
        super(pageName);
        this.selected = selected;
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(composite);
        Label filterLabel = new Label(composite, 16384);
        filterLabel.setText("Search:");
        final Text filterInput = new Text(composite, 128);
        filterInput.setMessage("Model Element class");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)filterInput);
        try {
            ECPMetaModelElementContext metaContext = ECPWorkspaceManager.getInstance().getWorkSpace().getActiveProject().getMetaModelElementContext();
            if (metaContext.isGuessed()) {
                Label label = new Label(composite, 0);
                label.setText("No registered Package found. EMF Client Platform has tried to guess your model package.\nPlease register your package explicitly.");
                GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)label);
            }
        }
        catch (NoWorkspaceException e) {
            Activator.getDefault().logException(e.getMessage(), (Exception)((Object)e));
        }
        catch (NullPointerException e) {
            Activator.getDefault().logException(e.getMessage(), e);
        }
        Tree tree = new Tree(composite, 4);
        final ModelClassFilter filter = new ModelClassFilter();
        filterInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = filterInput.getText();
                filter.setSearchTerm(text);
                ModelTreePage.this.treeViewer.expandAll();
                if (text != null && text.length() == 0) {
                    ModelTreePage.this.treeViewer.collapseAll();
                }
                ModelTreePage.this.treeViewer.refresh();
            }
        });
        this.treeViewer = new TreeViewer(tree);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).minSize(0, 150).span(2, 1).applyTo(this.treeViewer.getControl());
        this.treeViewer.setContentProvider((IContentProvider)new ModelTreeContentProvider(this.selected));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MEClassLabelProvider());
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.addFilter((ViewerFilter)filter);
        this.treeViewer.setInput(new Object());
        this.treeViewer.getTree().addListener(13, (Listener)this);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ModelTreePage.this.getWizard().canFinish()) {
                    ModelTreePage.this.getWizard().performFinish();
                    ModelTreePage.this.getWizard().getContainer().getShell().close();
                }
            }
        });
        this.setControl((Control)composite);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    private boolean checkSelection() {
        Object o;
        IStructuredSelection ssel;
        NewModelElementWizard wizard = (NewModelElementWizard)this.getWizard();
        boolean canFinish = false;
        ISelection sel = this.treeViewer.getSelection();
        if (sel == null) {
            canFinish = false;
        }
        if (!(sel instanceof IStructuredSelection)) {
            canFinish = false;
        }
        if ((ssel = (IStructuredSelection)sel).isEmpty()) {
            canFinish = false;
        }
        if (canFinish = (o = ssel.getFirstElement()) instanceof EClass) {
            EClass newMEType = (EClass)o;
            wizard.setNewMEType(newMEType);
            wizard.setTreePageCompleted(true);
            return true;
        }
        wizard.setNewMEType(null);
        wizard.setTreePageCompleted(false);
        return false;
    }

    public void handleEvent(Event event) {
        this.checkSelection();
        this.getWizard().getContainer().updateButtons();
    }
}

