/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphWithPerform;
import org.apache.jena.graph.impl.SimpleEventManager;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;

public class WrappedGraph
implements GraphWithPerform {
    protected final Graph base;
    protected GraphEventManager gem;

    public Graph getWrapped() {
        return this.base;
    }

    public WrappedGraph(Graph base) {
        this.base = base;
    }

    @Override
    public boolean dependsOn(Graph other) {
        return this.base.dependsOn(other);
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return this.base.getTransactionHandler();
    }

    @Override
    public Capabilities getCapabilities() {
        return this.base.getCapabilities();
    }

    @Override
    public GraphEventManager getEventManager() {
        if (this.gem == null) {
            this.gem = new SimpleEventManager();
        }
        return this.gem;
    }

    @Override
    public PrefixMapping getPrefixMapping() {
        return this.base.getPrefixMapping();
    }

    @Override
    public void add(Triple t) {
        this.base.add(t);
        this.getEventManager().notifyAddTriple(this, t);
    }

    @Override
    public void delete(Triple t) {
        this.base.delete(t);
        this.getEventManager().notifyDeleteTriple(this, t);
    }

    @Override
    public void clear() {
        this.base.clear();
        this.getEventManager().notifyEvent(this, GraphEvents.removeAll);
    }

    @Override
    public void remove(Node s, Node p, Node o) {
        this.base.remove(s, p, o);
        this.getEventManager().notifyEvent(this, GraphEvents.remove(s, p, o));
    }

    @Override
    public ExtendedIterator<Triple> find(Triple m) {
        return SimpleEventManager.notifyingRemove(this, this.base.find(m));
    }

    @Override
    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        return SimpleEventManager.notifyingRemove(this, this.base.find(s, p, o));
    }

    @Override
    public boolean isIsomorphicWith(Graph g) {
        return this.base.isIsomorphicWith(g);
    }

    @Override
    public boolean contains(Node s, Node p, Node o) {
        return this.base.contains(s, p, o);
    }

    @Override
    public boolean contains(Triple t) {
        return this.base.contains(t);
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public boolean isClosed() {
        return this.base.isClosed();
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public void performAdd(Triple t) {
        this.base.add(t);
    }

    @Override
    public void performDelete(Triple t) {
        this.base.delete(t);
    }
}

