/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.file;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.file.BlockAccess;
import org.apache.jena.dboe.base.file.FileException;
import org.apache.jena.dboe.sys.SysDB;

public class BlockAccessMem
implements BlockAccess {
    public static boolean SafeMode = true;
    static final boolean Checking = true;
    boolean fileClosed = false;
    private List<Block> blocks = new ArrayList<Block>();
    private final boolean safeModeThisMgr;
    protected final int blockSize;
    private final String label;

    public BlockAccessMem(String label, int blockSize) {
        this(label, blockSize, SafeMode);
    }

    private BlockAccessMem(String label, int blockSize, boolean b) {
        this.blockSize = blockSize;
        this.label = label;
        this.safeModeThisMgr = b;
    }

    @Override
    public Block allocate(int blkSize) {
        this.checkNotClosed();
        if (blkSize > 0 && blkSize != this.blockSize) {
            throw new FileException("Fixed blocksize only: request= " + blkSize + " / fixed size=" + this.blockSize);
        }
        int x = this.blocks.size();
        ByteBuffer bb = ByteBuffer.allocate(blkSize);
        Block block = new Block(x, bb);
        this.blocks.add(block);
        return block;
    }

    @Override
    public Block read(long id) {
        this.checkNotClosed();
        this.check(id);
        Block blk = this.blocks.get((int)id);
        blk = this.replicateBlock(blk);
        blk.setModified(false);
        return blk;
    }

    @Override
    public void write(Block block) {
        this.checkNotClosed();
        this.check(block);
        this._write(block);
    }

    @Override
    public void overwrite(Block block) {
        this.checkNotClosed();
        this.write(block);
    }

    private void _write(Block block) {
        block = this.replicateBlock(block);
        block.setModified(false);
        this.blocks.set(block.getId().intValue(), block);
    }

    private Block replicateBlock(Block blk) {
        if (this.safeModeThisMgr) {
            return blk.replicate();
        }
        return new Block(blk.getId(), blk.getByteBuffer());
    }

    @Override
    public boolean isEmpty() {
        this.checkNotClosed();
        return this.blocks.isEmpty();
    }

    @Override
    public long allocBoundary() {
        this.checkNotClosed();
        return this.blocks.size();
    }

    @Override
    public void resetAllocBoundary(long boundary) {
        this.checkNotClosed();
        this.blocks.subList((int)boundary, this.blocks.size()).clear();
    }

    @Override
    public boolean valid(long id) {
        this.checkNotClosed();
        return id >= 0L && id < (long)this.blocks.size();
    }

    private void checkNotClosed() {
        if (this.fileClosed) {
            throw new RuntimeIOException("Already closed");
        }
    }

    @Override
    public void close() {
        if (this.fileClosed) {
            return;
        }
        this.fileClosed = true;
        this.blocks = null;
    }

    @Override
    public void sync() {
        this.checkNotClosed();
    }

    private void check(Block block) {
        this.check(block.getId());
        this.check(block.getByteBuffer());
    }

    private void check(long id) {
        if (id > Integer.MAX_VALUE) {
            throw new FileException("BlockAccessMem: Bounds exception (id large than an int): " + id);
        }
        if (id < 0L || id >= (long)this.blocks.size()) {
            throw new FileException("BlockAccessMem: " + this.label + ": Bounds exception: " + id + " in [0, " + this.blocks.size() + ")");
        }
    }

    private void check(ByteBuffer bb) {
        if (bb.capacity() != this.blockSize) {
            throw new FileException(String.format("FileAccessMem: Wrong size block.  Expected=%d : actual=%d", this.blockSize, bb.capacity()));
        }
        if (bb.order() != SysDB.NetworkOrder) {
            throw new FileException("BlockMgrMem: Wrong byte order");
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return "Mem:" + this.label;
    }
}

