/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.model.Metadata;
import com.google.gdata.model.MetadataCreator;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.Path;
import com.google.gdata.model.QName;
import com.google.gdata.model.TransformKey;
import com.google.gdata.util.common.base.Preconditions;

abstract class MetadataCreatorImpl
implements MetadataCreator {
    final MetadataRegistry registry;
    final TransformKey transformKey;
    private QName name;
    private Boolean required;
    private Boolean visible;
    private Metadata.VirtualValue virtualValue;
    private TransformKey source;
    private Path path;
    private boolean isMoved;

    MetadataCreatorImpl(MetadataRegistry root, TransformKey transformKey) {
        this.registry = root;
        this.transformKey = transformKey;
    }

    void merge(MetadataCreatorImpl other) {
        Preconditions.checkNotNull(other, "other");
        if (other.name != null) {
            this.name = other.name;
        }
        if (other.required != null) {
            this.required = other.required;
        }
        if (other.visible != null) {
            this.visible = other.visible;
        }
        if (other.virtualValue != null) {
            this.virtualValue = other.virtualValue;
        }
        if (other.source != null) {
            this.source = other.source;
        }
        if (other.path != null) {
            this.path = other.path;
        }
        if (other.isMoved) {
            this.isMoved = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataCreatorImpl setName(QName name) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.name = name;
            this.registry.dirty();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataCreatorImpl setRequired(boolean required) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.required = required;
            this.registry.dirty();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataCreatorImpl setVisible(boolean visible) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.visible = visible;
            this.registry.dirty();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataCreatorImpl setVirtualValue(Metadata.VirtualValue virtualValue) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.virtualValue = virtualValue;
            this.registry.dirty();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSource(Path path, TransformKey key) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.path = path;
            this.source = key;
            this.registry.dirty();
            if (this.required == null) {
                this.setRequired(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MetadataCreatorImpl moved() {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.isMoved = true;
            this.registry.dirty();
        }
        return this;
    }

    TransformKey getTransformKey() {
        return this.transformKey;
    }

    QName getName() {
        return this.name;
    }

    Boolean getRequired() {
        return this.required;
    }

    Boolean getVisible() {
        return this.visible;
    }

    Metadata.VirtualValue getVirtualValue() {
        return this.virtualValue;
    }

    TransformKey getSource() {
        return this.source;
    }

    public Path getPath() {
        return this.path;
    }

    boolean isMoved() {
        return this.isMoved;
    }
}

