/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.options;

import org.eclipse.escet.cif.common.CifValidationUtils;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;

public class CodePrefixOption
extends StringOption {
    public CodePrefixOption() {
        super("Code prefix", "The code prefix, used to prefix file names, identifiers in the code, etc. If no prefix is given, the prefix is derived from the input filename, by removing the \".cif\" file extension, if present. This is also the default. The prefix must be a valid CIF identifier.", Character.valueOf('p'), "code-prefix", "PREFIX", null, true, true, "The code prefix, used to prefix file names, identifiers in the code, etc. The prefix must be a valid CIF identifier.If no prefix is given, the prefix is derived from the input filename, by removing the \".cif\" file extension (if present), and adapting the result to be a valid CIF identifier.", "Prefix:");
    }

    public static String getPrefix() {
        Object prefix = (String)Options.get(CodePrefixOption.class);
        if (prefix == null) {
            prefix = InputFileOption.getPath();
            prefix = Paths.getFileName((String)prefix);
            if (!CifValidationUtils.isValidIdentifier((String)(prefix = Paths.pathChangeExtension((String)prefix, (String)"cif", null)))) {
                if (((String)(prefix = ((String)prefix).replaceAll("[^A-Za-z0-9_]", "_"))).matches("[0-9].*")) {
                    prefix = "_" + (String)prefix;
                }
                Assert.check((boolean)CifValidationUtils.isValidIdentifier((String)prefix));
            }
            return prefix;
        }
        if (!CifValidationUtils.isValidIdentifier((String)prefix)) {
            String msg = Strings.fmt((String)"Code prefix \"%s\" specified using the code prefix option of the CIF code generator is not a valid CIF identifier.", (Object[])new Object[]{prefix});
            throw new InvalidOptionException(msg);
        }
        return prefix;
    }
}

