/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ElimTauEvent
extends CifWalker
implements CifToCifTransformation {
    private Map<Automaton, Event> newEventsMap = Maps.map();

    @Override
    public void transform(Specification spec) {
        this.walkSpecification(spec);
    }

    private Event getEvent(Automaton aut) {
        Event rslt = this.newEventsMap.get(aut);
        if (rslt == null) {
            rslt = CifConstructors.newEvent();
            this.newEventsMap.put(aut, rslt);
        }
        return rslt;
    }

    protected void preprocessEdge(Edge edge) {
        if (!edge.getEvents().isEmpty()) {
            return;
        }
        Location loc = (Location)edge.eContainer();
        Automaton aut = (Automaton)loc.eContainer();
        Event event = this.getEvent(aut);
        BoolType type = CifConstructors.newBoolType();
        EventExpression refExpr = CifConstructors.newEventExpression();
        refExpr.setEvent(event);
        refExpr.setType((CifType)type);
        EdgeEvent edgeEvent = CifConstructors.newEdgeEvent();
        edgeEvent.setEvent((Expression)refExpr);
        edge.getEvents().add((Object)edgeEvent);
    }

    protected void preprocessTauExpression(TauExpression tauExpr) {
        EdgeEvent edgeEvent = (EdgeEvent)tauExpr.eContainer();
        Edge edge = (Edge)edgeEvent.eContainer();
        Location loc = (Location)edge.eContainer();
        Automaton aut = (Automaton)loc.eContainer();
        Event event = this.getEvent(aut);
        BoolType type = CifConstructors.newBoolType();
        EventExpression refExpr = CifConstructors.newEventExpression();
        refExpr.setEvent(event);
        refExpr.setType((CifType)type);
        EMFHelper.updateParentContainment((EObject)tauExpr, (EObject)refExpr);
    }

    protected void postprocessAutomaton(Automaton aut) {
        if (!this.newEventsMap.containsKey(aut)) {
            return;
        }
        Event tauEvent = this.getEvent(aut);
        String name = "tau_";
        Set names = CifScopeUtils.getSymbolNamesForScope((PositionObject)aut, null);
        if (names.contains(name)) {
            String oldName = name;
            name = CifScopeUtils.getUniqueName((String)name, (Set)names, Collections.emptySet());
            OutputProvider.warn((String)"Event \"%s\", introduced for the elimination of the \"tau\" event, is renamed to \"%s\".", (Object[])new Object[]{oldName, name});
        }
        tauEvent.setName(name);
        aut.getDeclarations().add((Object)tauEvent);
        if (aut.getAlphabet() != null) {
            BoolType type = CifConstructors.newBoolType();
            EventExpression refExpr = CifConstructors.newEventExpression();
            refExpr.setEvent(tauEvent);
            refExpr.setType((CifType)type);
            aut.getAlphabet().getEvents().add((Object)refExpr);
        }
    }
}

