/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.List;
import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class TypeListSizeLimitsCheck
extends CifCheckNoCompDefInst {
    public static final int UNLIMITED = Integer.MIN_VALUE;
    private final int arrayLowestSize;
    private final int arrayHighestSize;
    private final int nonArrayLowestSize;
    private final int nonArrayHighestSize;
    private final ListTypesGrabber listTypesGrabber;

    public TypeListSizeLimitsCheck(int arrayLowestSize, int arrayHighestSize, int nonArrayLowestSize, int nonArrayHighestSize) {
        this.arrayLowestSize = arrayLowestSize;
        this.arrayHighestSize = arrayHighestSize;
        this.nonArrayLowestSize = nonArrayLowestSize;
        this.nonArrayHighestSize = nonArrayHighestSize;
        this.listTypesGrabber = new ListTypesGrabber();
    }

    protected void preprocessDeclaration(Declaration decl, CifCheckViolations violations) {
        if (decl instanceof AlgVariable) {
            AlgVariable algVar = (AlgVariable)decl;
            this.checkAlgVar(algVar, violations);
        } else if (decl instanceof Constant) {
            Constant constant = (Constant)decl;
            this.checkConstant(constant, violations);
        } else {
            if (decl instanceof ContVariable) {
                return;
            }
            if (decl instanceof DiscVariable) {
                DiscVariable discVar = (DiscVariable)decl;
                if (decl.eContainer() instanceof InternalFunction) {
                    this.checkDiscVar(discVar, "function variable", violations);
                } else if (decl.eContainer() instanceof FunctionParameter) {
                    this.checkDiscVar(discVar, "function parameter", violations);
                } else {
                    this.checkDiscVar(discVar, "discrete variable", violations);
                }
            } else {
                if (decl instanceof EnumDecl) {
                    return;
                }
                if (decl instanceof Event) {
                    Event event = (Event)decl;
                    if (event.getType() == null) {
                        return;
                    }
                    this.checkChannel(event, violations);
                } else if (decl instanceof InputVariable) {
                    InputVariable inpVar = (InputVariable)decl;
                    this.checkInputVar(inpVar, violations);
                } else {
                    if (decl instanceof TypeDecl) {
                        return;
                    }
                    if (decl instanceof Function) {
                        Function func = (Function)decl;
                        this.checkFunction(func, violations);
                    } else {
                        throw new AssertionError((Object)("Unexpected declaration \"" + String.valueOf(decl) + "\" found."));
                    }
                }
            }
        }
    }

    private void checkAlgVar(AlgVariable algVar, CifCheckViolations violations) {
        List<ListType> collectedListTypes = this.listTypesGrabber.collectListTypes(algVar.getType());
        if (collectedListTypes.isEmpty()) {
            return;
        }
        for (ListType listType : collectedListTypes) {
            String typeCamelText = CifTypeUtils.isArrayType((ListType)listType) ? "Array" : "List";
            String text = this.isTypeInTypeDeclaration((CifType)listType) ? Strings.fmt((String)"%s type of algebraic variable \"%s\" allows", (Object[])new Object[]{typeCamelText, CifTextUtils.getAbsName((PositionObject)algVar, (boolean)false)}) : Strings.fmt((String)"%s type of an algebraic variable allows", (Object[])new Object[]{typeCamelText});
            this.checkType(listType, text, violations);
        }
    }

    private void checkConstant(Constant constant, CifCheckViolations violations) {
        List<ListType> collectedListTypes = this.listTypesGrabber.collectListTypes(constant.getType());
        if (collectedListTypes.isEmpty()) {
            return;
        }
        for (ListType listType : collectedListTypes) {
            String typeCamelText = CifTypeUtils.isArrayType((ListType)listType) ? "Array" : "List";
            String text = this.isTypeInTypeDeclaration((CifType)listType) ? Strings.fmt((String)"%s type of constant \"%s\" allows", (Object[])new Object[]{typeCamelText, CifTextUtils.getAbsName((PositionObject)constant, (boolean)false)}) : Strings.fmt((String)"%s type of a constant allows", (Object[])new Object[]{typeCamelText});
            this.checkType(listType, text, violations);
        }
    }

    private void checkDiscVar(DiscVariable discVar, String varKind, CifCheckViolations violations) {
        List<ListType> collectedListTypes = this.listTypesGrabber.collectListTypes(discVar.getType());
        if (collectedListTypes.isEmpty()) {
            return;
        }
        for (ListType listType : collectedListTypes) {
            String typeCamelText = CifTypeUtils.isArrayType((ListType)listType) ? "Array" : "List";
            String text = this.isTypeInTypeDeclaration((CifType)listType) ? Strings.fmt((String)"%s type of %s \"%s\" allows", (Object[])new Object[]{typeCamelText, varKind, CifTextUtils.getAbsName((PositionObject)discVar, (boolean)false)}) : Strings.fmt((String)"%s type of a %s allows", (Object[])new Object[]{typeCamelText, varKind});
            this.checkType(listType, text, violations);
        }
    }

    private void checkChannel(Event channel, CifCheckViolations violations) {
        List<ListType> collectedListTypes = this.listTypesGrabber.collectListTypes(channel.getType());
        if (collectedListTypes.isEmpty()) {
            return;
        }
        for (ListType listType : collectedListTypes) {
            String typeCamelText = CifTypeUtils.isArrayType((ListType)listType) ? "Array" : "List";
            String text = this.isTypeInTypeDeclaration((CifType)listType) ? Strings.fmt((String)"%s type of channel \"%s\" allows", (Object[])new Object[]{typeCamelText, CifTextUtils.getAbsName((PositionObject)channel, (boolean)false)}) : Strings.fmt((String)"%s type of a channel allows", (Object[])new Object[]{typeCamelText});
            this.checkType(listType, text, violations);
        }
    }

    private void checkInputVar(InputVariable inputVar, CifCheckViolations violations) {
        List<ListType> collectedListTypes = this.listTypesGrabber.collectListTypes(inputVar.getType());
        if (collectedListTypes.isEmpty()) {
            return;
        }
        for (ListType listType : collectedListTypes) {
            String typeCamelText = CifTypeUtils.isArrayType((ListType)listType) ? "Array" : "List";
            String text = this.isTypeInTypeDeclaration((CifType)listType) ? Strings.fmt((String)"%s type of input variable \"%s\" allows", (Object[])new Object[]{typeCamelText, CifTextUtils.getAbsName((PositionObject)inputVar, (boolean)false)}) : Strings.fmt((String)"%s type of an input variable allows", (Object[])new Object[]{typeCamelText});
            this.checkType(listType, text, violations);
        }
    }

    private void checkFunction(Function func, CifCheckViolations violations) {
        List<ListType> collectedListTypes = this.listTypesGrabber.collectListTypes((List<CifType>)func.getReturnTypes());
        if (collectedListTypes.isEmpty()) {
            return;
        }
        for (ListType listType : collectedListTypes) {
            String typeCamelText = CifTypeUtils.isArrayType((ListType)listType) ? "Array" : "List";
            String text = this.isTypeInTypeDeclaration((CifType)listType) ? Strings.fmt((String)"%s type of a return type of function \"%s\" allows", (Object[])new Object[]{typeCamelText, CifTextUtils.getAbsName((PositionObject)func, (boolean)false)}) : Strings.fmt((String)"%s type of a return type of a function allows", (Object[])new Object[]{typeCamelText});
            this.checkType(listType, text, violations);
        }
    }

    private void checkType(ListType listType, String explainText, CifCheckViolations violations) {
        if (CifTypeUtils.isArrayType((ListType)listType)) {
            if (this.arrayLowestSize > 0 && listType.getLower() < this.arrayLowestSize) {
                this.reportViolation(violations, listType, explainText, "less than", this.arrayLowestSize);
            }
            if (this.arrayHighestSize >= 0 && listType.getLower() > this.arrayHighestSize) {
                this.reportViolation(violations, listType, explainText, "more than", this.arrayHighestSize);
            }
        } else {
            if (this.nonArrayLowestSize > 0 && CifTypeUtils.getLowerBound((ListType)listType) < this.nonArrayLowestSize) {
                this.reportViolation(violations, listType, explainText, "less than", this.nonArrayLowestSize);
            }
            if (this.nonArrayHighestSize >= 0 && CifTypeUtils.getUpperBound((ListType)listType) > this.nonArrayHighestSize) {
                this.reportViolation(violations, listType, explainText, "more than", this.nonArrayHighestSize);
            }
        }
    }

    private void reportViolation(CifCheckViolations violations, ListType listType, String explainText, String boundaryKind, int boundary) {
        String typeText = CifTypeUtils.isArrayType((ListType)listType) ? "arrays" : "lists";
        String pluralSuffix = boundary == 1 ? "" : "s";
        violations.add((PositionObject)listType, Strings.fmt((String)"%s %s with %s %d element%s", (Object[])new Object[]{explainText, typeText, boundaryKind, boundary, pluralSuffix}), new Object[0]);
    }

    private boolean isTypeInTypeDeclaration(CifType type) {
        CifType eObj = type;
        while (eObj != null && eObj instanceof CifType) {
            eObj = eObj.eContainer();
        }
        return eObj instanceof TypeDecl;
    }

    private static class ListTypesGrabber
    extends CifWalker {
        private final List<ListType> listTypes = Lists.list();

        private ListTypesGrabber() {
        }

        private List<ListType> collectListTypes(CifType type) {
            this.listTypes.clear();
            this.walkCifType(type);
            return this.listTypes;
        }

        private List<ListType> collectListTypes(List<CifType> types) {
            this.listTypes.clear();
            for (CifType type : types) {
                this.walkCifType(type);
            }
            return this.listTypes;
        }

        protected void preprocessListType(ListType listType) {
            this.listTypes.add(listType);
        }

        protected void preprocessTypeRef(TypeRef typeRef) {
            this.walkCifType(typeRef.getType().getType());
        }
    }
}

