/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.multivaluetrees;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.multivaluetrees.VarInfo;

public abstract class VarInfoBuilder<V> {
    public final int numUseKinds;
    private final Map<V, VarInfo[]> varInfosByVariable = Maps.map();
    private final Map<VarInfo, V> variableByVarInfo = Maps.map();
    public final List<VarInfo> varInfos = Lists.list();

    public VarInfoBuilder(int numUseKinds) {
        this.numUseKinds = numUseKinds;
    }

    public VarInfo addVariable(V var, int useKind) {
        Assert.check((useKind >= 0 && useKind < this.numUseKinds ? 1 : 0) != 0);
        VarInfo[] vis = this.varInfosByVariable.get(var);
        if (vis == null) {
            vis = new VarInfo[this.numUseKinds];
            this.varInfosByVariable.put((VarInfo[])var, vis);
        }
        Assert.areEqual((Object)vis[useKind], null, (Object)"Varinfo is already created.");
        String name = this.getName(var);
        int lower = this.getLowerBound(var);
        int length = this.getNumValues(var);
        VarInfo vi = new VarInfo(this.varInfos.size(), name, useKind, lower, length);
        this.varInfos.add(vi);
        vis[useKind] = vi;
        this.variableByVarInfo.put(vi, var);
        return vi;
    }

    public VarInfo[] addVariable(V var) {
        int useKind = 0;
        while (useKind < this.numUseKinds) {
            this.addVariable(var, useKind);
            ++useKind;
        }
        return this.varInfosByVariable.get(var);
    }

    public void addVariablesGroupOnVariable(List<V> vars) {
        for (V var : vars) {
            this.addVariable(var);
        }
    }

    public void addVariablesGroupOnUseKind(List<V> vars) {
        int useKind = 0;
        while (useKind < this.numUseKinds) {
            for (V var : vars) {
                this.addVariable(var, useKind);
            }
            ++useKind;
        }
    }

    public VarInfo[] getVarInfos(V var) {
        VarInfo[] varInfos = this.varInfosByVariable.get(var);
        Assert.notNull((Object)varInfos);
        return varInfos;
    }

    public VarInfo getVarInfo(V var, int useKind) {
        VarInfo[] varInfos = this.getVarInfos(var);
        Assert.notNull((Object)varInfos[useKind]);
        return varInfos[useKind];
    }

    public V getVariable(VarInfo varInfo) {
        V var = this.variableByVarInfo.get(varInfo);
        Assert.notNull(var);
        return var;
    }

    protected abstract String getName(V var1);

    protected abstract int getLowerBound(V var1);

    protected abstract int getNumValues(V var1);
}

