/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class IndexableDeque<T>
implements Iterable<T> {
    private static final int DEFAULT_MINIMAL_SIZE = 8;
    private T[] data;
    private int head;
    private int tail;

    public IndexableDeque() {
        this(0);
    }

    public IndexableDeque(int initElements) {
        int sz = IndexableDeque.computeSize(0, initElements + 1);
        this.data = new Object[sz];
        this.clear();
    }

    public IndexableDeque(IndexableDeque<T> orig) {
        this.data = new Object[orig.data.length];
        this.head = orig.head;
        this.tail = orig.tail;
        System.arraycopy(orig.data, 0, this.data, 0, orig.data.length);
    }

    public IndexableDeque(int bufferSize, T[] data, int head) {
        Assert.check((bufferSize > data.length ? 1 : 0) != 0);
        Assert.check((head >= 0 && head < bufferSize ? 1 : 0) != 0);
        this.data = new Object[bufferSize];
        this.clear();
        this.head = head;
        this.tail = head;
        int i = 0;
        while (i < data.length) {
            this.data[this.tail] = data[i];
            this.tail = this.tail == this.data.length - 1 ? 0 : this.tail + 1;
            ++i;
        }
    }

    private void clear() {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = null;
            ++i;
        }
        this.head = 0;
        this.tail = 0;
    }

    private static int computeSize(int currentSize, int minimalSize) {
        if (currentSize < 8) {
            currentSize = 8;
        }
        while (currentSize < minimalSize) {
            currentSize = currentSize < 1024 ? (currentSize *= 2) : (currentSize += currentSize / 16);
            Assert.check((currentSize >= 8 ? 1 : 0) != 0);
        }
        return currentSize;
    }

    private void enlargeStorage(int minimalElements) {
        int newSize = IndexableDeque.computeSize(this.data.length, minimalElements + 1);
        Object[] newData = new Object[newSize];
        int i = 0;
        while (i < newSize) {
            newData[i] = null;
            ++i;
        }
        if (this.head <= this.tail) {
            System.arraycopy(this.data, this.head, newData, 0, this.tail - this.head);
            this.tail -= this.head;
            this.head = 0;
        } else {
            System.arraycopy(this.data, 0, newData, 0, this.tail);
            int count = this.data.length - this.head;
            int newHead = newSize - count;
            Assert.check((newHead > this.tail ? 1 : 0) != 0);
            System.arraycopy(this.data, this.head, newData, newHead, count);
            this.head = newHead;
        }
        this.data = newData;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail + (this.data.length - this.head);
    }

    public int capacity() {
        return this.data.length;
    }

    public int normalizeIndex(int index, boolean allowSize) {
        int sz = this.size();
        if (index < 0) {
            if ((index += sz) < 0) {
                String msg = Strings.fmt((String)"Array index is too small (index %d does not exist for a list with %d elements).", (Object[])new Object[]{index - sz, this.size()});
                throw new ChiSimulatorException(msg);
            }
            return index;
        }
        if (index > sz || !allowSize && index == sz) {
            String msg = Strings.fmt((String)"Array index is too large (index %d does not exist for a list with %d elements).", (Object[])new Object[]{index, this.size()});
            throw new ChiSimulatorException(msg);
        }
        return index;
    }

    public T get(int index) {
        index = this.normalizeIndex(index, false) + this.head;
        if (this.head > this.tail && index >= this.data.length) {
            return this.data[index - this.data.length];
        }
        return this.data[index];
    }

    public void set(int index, T newVal) {
        index = this.normalizeIndex(index, false) + this.head;
        if (this.head > this.tail && index >= this.data.length) {
            this.data[index - this.data.length] = newVal;
            return;
        }
        this.data[index] = newVal;
    }

    public void prepend(T value) {
        int prev = this.head - 1;
        if (prev < 0) {
            prev = this.data.length - 1;
        }
        if (prev != this.tail) {
            this.data[prev] = value;
            this.head = prev;
        } else {
            this.enlargeStorage(this.data.length);
            this.head = this.head == 0 ? this.data.length - 1 : this.head - 1;
            this.data[this.head] = value;
        }
    }

    public void append(T value) {
        int next = this.tail + 1;
        if (next == this.data.length) {
            next = 0;
        }
        if (next != this.head) {
            this.data[this.tail] = value;
            this.tail = next;
        } else {
            this.enlargeStorage(this.data.length);
            this.data[this.tail] = value;
            this.tail = this.tail == this.data.length - 1 ? 0 : this.tail + 1;
        }
    }

    public T removeHead() {
        if (this.isEmpty()) {
            String msg = "Cannot remove the first element from an empty list.";
            throw new ChiSimulatorException(msg);
        }
        T value = this.data[this.head];
        this.data[this.head] = null;
        this.head = this.head == this.data.length - 1 ? 0 : this.head + 1;
        return value;
    }

    public T removeTail() {
        if (this.isEmpty()) {
            String msg = "Cannot remove the last element from an empty list.";
            throw new ChiSimulatorException(msg);
        }
        this.tail = this.tail == 0 ? this.data.length - 1 : this.tail - 1;
        T value = this.data[this.tail];
        this.data[this.tail] = null;
        return value;
    }

    public Object[] copyToArray(T[] array) {
        if (array == null || array.length < this.size()) {
            array = new Object[this.size()];
        }
        if (this.head < this.tail) {
            System.arraycopy(this.data, this.head, array, 0, this.tail - this.head);
            return array;
        }
        if (this.head > this.tail) {
            System.arraycopy(this.data, this.head, array, 0, this.data.length - this.head);
            System.arraycopy(this.data, 0, array, this.data.length - this.head, this.tail);
        }
        return array;
    }

    public void insert(int idx, T val) {
        idx = this.normalizeIndex(idx, true);
        if (this.size() + 1 == this.data.length) {
            this.enlargeStorage(this.data.length);
        }
        idx += this.head;
        if (this.head <= this.tail) {
            if (idx - this.head > this.tail - idx) {
                System.arraycopy(this.data, idx, this.data, idx + 1, this.tail - idx);
                this.data[idx] = val;
                this.tail = this.tail == this.data.length - 1 ? 0 : this.tail + 1;
                return;
            }
            if (idx > this.head) {
                if (this.head == 0) {
                    this.data[this.data.length - 1] = this.data[0];
                    System.arraycopy(this.data, 1, this.data, 0, idx - 1);
                } else {
                    System.arraycopy(this.data, this.head, this.data, this.head - 1, idx - this.head);
                }
            }
            idx = idx == 0 ? this.data.length - 1 : idx - 1;
            this.data[idx] = val;
            this.head = this.head == 0 ? this.data.length - 1 : this.head - 1;
            return;
        }
        if (idx >= this.data.length) {
            System.arraycopy(this.data, idx -= this.data.length, this.data, idx + 1, this.tail - idx);
            this.data[idx] = val;
            this.tail = this.tail == this.data.length - 1 ? 0 : this.tail + 1;
            return;
        }
        System.arraycopy(this.data, this.head, this.data, this.head - 1, idx - this.head);
        this.data[idx - 1] = val;
        this.head = this.head == 0 ? this.data.length - 1 : this.head - 1;
    }

    public T remove(int idx) {
        idx = this.normalizeIndex(idx, false) + this.head;
        if (this.head <= this.tail) {
            T val = this.data[idx];
            if (idx - this.head > this.tail - idx) {
                System.arraycopy(this.data, idx + 1, this.data, idx, this.tail - idx - 1);
                --this.tail;
                this.data[this.tail] = null;
            } else {
                System.arraycopy(this.data, this.head, this.data, this.head + 1, idx - this.head);
                this.data[this.head] = null;
                ++this.head;
            }
            return val;
        }
        if (idx >= this.data.length) {
            T val = this.data[idx -= this.data.length];
            System.arraycopy(this.data, idx + 1, this.data, idx, this.tail - idx - 1);
            --this.tail;
            this.data[this.tail] = null;
            return val;
        }
        T val = this.data[idx];
        System.arraycopy(this.data, this.head, this.data, this.head + 1, idx - this.head);
        this.data[this.head] = null;
        this.head = this.head == this.data.length - 1 ? 0 : this.head + 1;
        return val;
    }

    public void insert(T elm, Comparator<T> comp) {
        int lower = -1;
        int upper = this.size();
        while (lower + 1 < upper) {
            int middle = (lower + upper) / 2;
            if (comp.compare(this.get(middle), elm) < 0) {
                lower = middle;
                continue;
            }
            upper = middle;
        }
        if (upper == this.size()) {
            this.append(elm);
        } else {
            this.insert(upper, elm);
        }
    }

    public void sort(Comparator<T> comp) {
        int end;
        if (this.size() <= 1) {
            return;
        }
        if (this.head < this.tail) {
            end = this.tail;
        } else {
            int blk = 0;
            int length = this.tail;
            if (this.head - this.tail < length) {
                blk = 1;
                length = this.head - this.tail;
            }
            if (this.data.length - this.head < length) {
                blk = 2;
                length = this.data.length - this.head;
            }
            switch (blk) {
                case 0: {
                    System.arraycopy(this.data, 0, this.data, this.head - length, length);
                    this.head -= length;
                    this.tail = 0;
                    end = this.data.length;
                    int i = 0;
                    while (i < this.head) {
                        this.data[i] = null;
                        ++i;
                    }
                    break;
                }
                case 1: {
                    System.arraycopy(this.data, 0, this.data, this.tail, length);
                    this.head = length;
                    this.tail = 0;
                    end = this.data.length;
                    int i = 0;
                    while (i < this.head) {
                        this.data[i] = null;
                        ++i;
                    }
                    break;
                }
                case 2: {
                    System.arraycopy(this.data, this.head, this.data, this.tail, length);
                    this.head = 0;
                    this.tail += length;
                    end = this.tail;
                    int i = this.tail;
                    while (i < this.data.length) {
                        this.data[i] = null;
                        ++i;
                    }
                    break;
                }
                default: {
                    end = this.head;
                }
            }
        }
        Arrays.sort(this.data, this.head, end, comp);
    }

    public boolean contains(T elm) {
        int idx = this.head;
        while (idx != this.tail) {
            if (this.data[idx].equals(elm)) {
                return true;
            }
            if (++idx != this.data.length) continue;
            idx = 0;
        }
        return false;
    }

    public Iterator<T> iterator(int start, int step, int end) {
        return new IndexableDequeIterator(start, step, end);
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(0, 1, this.size());
    }

    public Iterator<T> descendingIterator() {
        return this.iterator(this.size() - 1, -1, -1);
    }

    public int hashCode() {
        int hash = 387;
        int idx = this.head;
        int n = 1;
        while (idx != this.tail) {
            hash += n * this.data[idx].hashCode();
            n = n % 32 + 1;
            if (++idx != this.data.length) continue;
            idx = 0;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IndexableDeque)) {
            return false;
        }
        IndexableDeque other = (IndexableDeque)obj;
        if (this.size() != other.size()) {
            return false;
        }
        int thisIdx = this.head;
        int otherIdx = other.head;
        while (thisIdx != this.tail) {
            if (!this.data[thisIdx].equals(other.data[otherIdx])) {
                return false;
            }
            if (++thisIdx >= this.data.length) {
                thisIdx = 0;
            }
            if (++otherIdx < other.data.length) continue;
            otherIdx = 0;
        }
        return true;
    }

    protected final class IndexableDequeIterator
    implements Iterator<T> {
        private int position;
        private int step;
        private int end;

        public IndexableDequeIterator(int start, int step, int end) {
            int length = IndexableDeque.this.size();
            int n = this.step = step == 0 ? 1 : step;
            if (this.step > 0) {
                if (start < 0) {
                    start = 0;
                }
                if (end > length) {
                    end = length;
                }
            } else {
                if (start > length - 1) {
                    start = length - 1;
                }
                if (end < -1) {
                    end = -1;
                }
            }
            this.position = start;
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            if (this.step > 0) {
                return this.position < this.end;
            }
            return this.position > this.end;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object value = IndexableDeque.this.get(this.position);
            this.position += this.step;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

