/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.simulator.options;

import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SeedValueOption
extends Option<Integer> {
    public static long getSeedValue() {
        Integer value = (Integer)Options.get(SeedValueOption.class);
        if (value == null) {
            return 0L;
        }
        return value.intValue();
    }

    public SeedValueOption() {
        super("Initial seed", "Initial seed value for the random number generators (0 means derive one from the system) [default=0].", Character.valueOf('s'), "seed", "SEED", true);
    }

    public Integer getDefault() {
        return 0;
    }

    public Integer parseValue(String optName, String value) {
        Integer val;
        try {
            val = Integer.parseInt(value, 10);
        }
        catch (NumberFormatException e) {
            String msg = Strings.fmt((String)"Cannot parse \"%s\" to an int number.", (Object[])new Object[]{value});
            throw new InvalidOptionException(msg, (Throwable)e);
        }
        return val;
    }

    public String[] getCmdLine(Object value) {
        if (value == null) {
            return new String[0];
        }
        int val = (Integer)value;
        return new String[]{"--seed=" + String.valueOf(val)};
    }

    public OptionGroup<Integer> createOptionGroup(Composite page) {
        return new OptionGroup<Integer>(page, Options.getInstance(SeedValueOption.class)){
            Label instanceLabel;
            Text instanceText;

            protected void addComponents(Group group) {
                this.instanceLabel = new Label((Composite)group, 0);
                this.instanceLabel.setText("Initial seed value:");
                this.instanceText = new Text((Composite)group, 2052);
                this.layoutGeneric(new Object[]{new Control[]{this.instanceLabel, this.instanceText}}, 0);
            }

            public String getDescription() {
                return "The initial seed (\"0\" means that one is generated).";
            }

            public void setToValue(Integer value) {
                this.instanceText.setText(value == null ? "" : String.valueOf(value));
            }

            public String[] getCmdLine() {
                return new String[]{"--seed=" + this.instanceText.getText()};
            }
        };
    }
}

