/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.types.BooleanTypeID;
import org.eclipse.escet.chi.codegen.types.ChannelTypeID;
import org.eclipse.escet.chi.codegen.types.DictionaryTypeID;
import org.eclipse.escet.chi.codegen.types.DistributionTypeID;
import org.eclipse.escet.chi.codegen.types.EnumTypeID;
import org.eclipse.escet.chi.codegen.types.FileTypeID;
import org.eclipse.escet.chi.codegen.types.FunctionTypeID;
import org.eclipse.escet.chi.codegen.types.InstanceTypeID;
import org.eclipse.escet.chi.codegen.types.IntTypeID;
import org.eclipse.escet.chi.codegen.types.ListTypeID;
import org.eclipse.escet.chi.codegen.types.MatrixTypeID;
import org.eclipse.escet.chi.codegen.types.ProcessTypeID;
import org.eclipse.escet.chi.codegen.types.RealTypeID;
import org.eclipse.escet.chi.codegen.types.SetTypeID;
import org.eclipse.escet.chi.codegen.types.StringTypeID;
import org.eclipse.escet.chi.codegen.types.TimerTypeID;
import org.eclipse.escet.chi.codegen.types.TupleTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.metamodel.chi.BehaviourDeclaration;
import org.eclipse.escet.chi.metamodel.chi.BoolType;
import org.eclipse.escet.chi.metamodel.chi.ChannelType;
import org.eclipse.escet.chi.metamodel.chi.DictType;
import org.eclipse.escet.chi.metamodel.chi.DistributionType;
import org.eclipse.escet.chi.metamodel.chi.EnumDeclaration;
import org.eclipse.escet.chi.metamodel.chi.EnumTypeReference;
import org.eclipse.escet.chi.metamodel.chi.FileType;
import org.eclipse.escet.chi.metamodel.chi.FunctionDeclaration;
import org.eclipse.escet.chi.metamodel.chi.FunctionType;
import org.eclipse.escet.chi.metamodel.chi.InstanceType;
import org.eclipse.escet.chi.metamodel.chi.IntType;
import org.eclipse.escet.chi.metamodel.chi.ListType;
import org.eclipse.escet.chi.metamodel.chi.MatrixType;
import org.eclipse.escet.chi.metamodel.chi.ModelDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ProcessDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ProcessType;
import org.eclipse.escet.chi.metamodel.chi.RealType;
import org.eclipse.escet.chi.metamodel.chi.SetType;
import org.eclipse.escet.chi.metamodel.chi.StringType;
import org.eclipse.escet.chi.metamodel.chi.TimerType;
import org.eclipse.escet.chi.metamodel.chi.TupleField;
import org.eclipse.escet.chi.metamodel.chi.TupleType;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.TypeReference;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.chi.metamodel.chi.VoidType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class TypeIDCreation {
    private TypeIDCreation() {
    }

    public static TypeID createTypeID(Type tp, CodeGeneratorContext ctxt) {
        if ((tp = TypeIDCreation.dropTypeReferences(tp)) instanceof BoolType) {
            return TypeIDCreation.makeBooleanTypeID();
        }
        if (tp instanceof IntType) {
            return TypeIDCreation.makeIntTypeID();
        }
        if (tp instanceof StringType) {
            return TypeIDCreation.makeStringTypeID();
        }
        if (tp instanceof RealType) {
            return new RealTypeID();
        }
        if (tp instanceof InstanceType) {
            return new InstanceTypeID();
        }
        if (tp instanceof EnumTypeReference) {
            EnumTypeReference etr = (EnumTypeReference)tp;
            return TypeIDCreation.createEnumTypeID(etr.getType(), ctxt);
        }
        if (tp instanceof MatrixType) {
            return new MatrixTypeID((MatrixType)tp);
        }
        if (tp instanceof ChannelType) {
            return TypeIDCreation.makeChannelTypeID((ChannelType)tp, ctxt);
        }
        if (tp instanceof TupleType) {
            return TypeIDCreation.makeTupleTypeID((TupleType)tp, ctxt);
        }
        if (tp instanceof FunctionType) {
            return TypeIDCreation.makeFunctionTypeID((FunctionType)tp, ctxt);
        }
        if (tp instanceof ProcessType) {
            return TypeIDCreation.makeProcessTypeID((ProcessType)tp, ctxt);
        }
        if (tp instanceof ListType) {
            return TypeIDCreation.makeListTypeID((ListType)tp, ctxt);
        }
        if (tp instanceof SetType) {
            return TypeIDCreation.makeSetTypeID((SetType)tp, ctxt);
        }
        if (tp instanceof DictType) {
            return TypeIDCreation.makeDictTypeID((DictType)tp, ctxt);
        }
        if (tp instanceof DistributionType) {
            return TypeIDCreation.makeDistributionTypeID((DistributionType)tp, ctxt);
        }
        if (tp instanceof TimerType) {
            return new TimerTypeID();
        }
        if (tp instanceof FileType) {
            return new FileTypeID();
        }
        Assert.fail((Object)("Unhandled type '" + tp.toString() + "' encountered in createTypeID."));
        return null;
    }

    public static EnumTypeID createEnumTypeID(EnumDeclaration decl, CodeGeneratorContext ctxt) {
        return new EnumTypeID(decl, ctxt);
    }

    public static BooleanTypeID makeBooleanTypeID() {
        return new BooleanTypeID();
    }

    public static IntTypeID makeIntTypeID() {
        return new IntTypeID();
    }

    public static StringTypeID makeStringTypeID() {
        return new StringTypeID();
    }

    public static TypeID createProcessTypeID(BehaviourDeclaration bd, CodeGeneratorContext ctxt) {
        Assert.check((bd instanceof ProcessDeclaration || bd instanceof ModelDeclaration ? 1 : 0) != 0);
        List args = Lists.list();
        for (VariableDeclaration vd : bd.getVariables()) {
            if (!vd.isParameter()) continue;
            args.add(TypeIDCreation.createTypeID(vd.getType(), ctxt));
        }
        return new ProcessTypeID(args, ctxt);
    }

    private static TypeID makeProcessTypeID(ProcessType p, CodeGeneratorContext ctxt) {
        List subs = Lists.list();
        for (Type arg : p.getParameterTypes()) {
            subs.add(TypeIDCreation.createTypeID(arg, ctxt));
        }
        return new ProcessTypeID(subs, ctxt);
    }

    private static TypeID makeDistributionTypeID(DistributionType s, CodeGeneratorContext ctxt) {
        return new DistributionTypeID(TypeIDCreation.createTypeID(s.getResultType(), ctxt));
    }

    private static TypeID makeChannelTypeID(ChannelType c, CodeGeneratorContext ctxt) {
        Type tp = TypeIDCreation.dropTypeReferences(c.getElementType());
        TypeID dataType = tp instanceof VoidType ? null : TypeIDCreation.createTypeID(tp, ctxt);
        return new ChannelTypeID(dataType);
    }

    public static TypeID createFunctionTypeID(FunctionDeclaration fd, CodeGeneratorContext ctxt) {
        List subs = Lists.list();
        for (VariableDeclaration vd : fd.getVariables()) {
            if (!vd.isParameter()) continue;
            subs.add(TypeIDCreation.createTypeID(vd.getType(), ctxt));
        }
        subs.add(TypeIDCreation.createTypeID(fd.getReturnType(), ctxt));
        return new FunctionTypeID(subs, ctxt);
    }

    private static TypeID makeFunctionTypeID(FunctionType f, CodeGeneratorContext ctxt) {
        List subs = Lists.list();
        for (Type arg : f.getParameterTypes()) {
            subs.add(TypeIDCreation.createTypeID(arg, ctxt));
        }
        subs.add(TypeIDCreation.createTypeID(f.getResultType(), ctxt));
        return TypeIDCreation.makeFunctionTypeID(subs, ctxt);
    }

    public static TypeID makeFunctionTypeID(List<TypeID> subs, CodeGeneratorContext ctxt) {
        return new FunctionTypeID(subs, ctxt);
    }

    private static TypeID makeTupleTypeID(TupleType t, CodeGeneratorContext ctxt) {
        List fieldNames = Lists.list();
        List subs = Lists.list();
        for (TupleField arg : t.getFields()) {
            if (arg.getName() == null) {
                fieldNames.add("");
            } else {
                fieldNames.add(arg.getName());
            }
            subs.add(TypeIDCreation.createTypeID(arg.getType(), ctxt));
        }
        return TypeIDCreation.createTupleTypeID(fieldNames, subs, ctxt);
    }

    public static TypeID createTupleTypeID(List<String> fieldNames, List<TypeID> subs, CodeGeneratorContext ctxt) {
        return new TupleTypeID(fieldNames, subs, ctxt);
    }

    private static TypeID makeListTypeID(ListType l, CodeGeneratorContext ctxt) {
        TypeID tid = TypeIDCreation.createTypeID(l.getElementType(), ctxt);
        return TypeIDCreation.makeListTypeID(tid, ctxt);
    }

    public static TypeID makeListTypeID(TypeID elmTid, CodeGeneratorContext ctxt) {
        return new ListTypeID(elmTid, ctxt);
    }

    private static TypeID makeSetTypeID(SetType st, CodeGeneratorContext ctxt) {
        TypeID eTid = TypeIDCreation.createTypeID(st.getElementType(), ctxt);
        return TypeIDCreation.makeSetTypeID(eTid, ctxt);
    }

    public static TypeID makeSetTypeID(TypeID elmTid, CodeGeneratorContext ctxt) {
        return new SetTypeID(elmTid, ctxt);
    }

    private static TypeID makeDictTypeID(DictType dtp, CodeGeneratorContext ctxt) {
        TypeID kTid = TypeIDCreation.createTypeID(dtp.getKeyType(), ctxt);
        TypeID vTid = TypeIDCreation.createTypeID(dtp.getValueType(), ctxt);
        return new DictionaryTypeID(kTid, vTid, ctxt);
    }

    public static Type dropTypeReferences(Type tp) {
        int count = 0;
        while (tp instanceof TypeReference) {
            Assert.check((count < 10000 ? 1 : 0) != 0);
            tp = ((TypeReference)tp).getType().getType();
            ++count;
        }
        return tp;
    }
}

