/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.event;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;

public class MethodExprValueChangeListener
implements ValueChangeListener,
StateHolder {
    private MethodExpression methodExpression = null;
    private boolean isTransient;

    public MethodExprValueChangeListener() {
    }

    public MethodExprValueChangeListener(MethodExpression methodExpression) {
        this.methodExpression = methodExpression;
    }

    public void processValueChange(ValueChangeEvent valueChangeEvent) throws AbortProcessingException {
        if (valueChangeEvent == null) {
            throw new NullPointerException();
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            ELContext elContext = context.getELContext();
            this.methodExpression.invoke(elContext, new Object[]{valueChangeEvent});
        }
        catch (ELException ee) {
            throw new AbortProcessingException(ee.getMessage(), ee.getCause());
        }
    }

    public Object saveState(FacesContext context) {
        return new Object[]{this.methodExpression};
    }

    public void restoreState(FacesContext context, Object state) {
        this.methodExpression = (MethodExpression)((Object[])state)[0];
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    public MethodExpression getMethodExpression() {
        return this.methodExpression;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof MethodExprValueChangeListener)) {
            return false;
        }
        MethodExprValueChangeListener other = (MethodExprValueChangeListener)otherObject;
        MethodExpression otherMe = other.getMethodExpression();
        return this.methodExpression.equals((Object)otherMe);
    }
}

