/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.datastructure;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.enterprise.resource.pool.datastructure.strategy.ResourceSelectionStrategy;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

public class ListDataStructure
implements DataStructure {
    private final ArrayList<ResourceHandle> free;
    private final ArrayList<ResourceHandle> resources;
    private int maxSize;
    private final DynamicSemaphore dynSemaphore;
    private ResourceHandler handler;
    private ResourceSelectionStrategy strategy;

    public ListDataStructure(String parameters, int maxSize, ResourceHandler handler, String strategyClass) {
        this.resources = new ArrayList(maxSize > 1000 ? 1000 : maxSize);
        this.free = new ArrayList(maxSize > 1000 ? 1000 : maxSize);
        this.handler = handler;
        this.initializeStrategy(strategyClass);
        this.dynSemaphore = new DynamicSemaphore();
        this.setMaxSize(maxSize);
    }

    @Override
    public synchronized void setMaxSize(int newMaxSize) {
        int permits = newMaxSize - this.maxSize;
        if (permits == 0) {
            return;
        }
        if (permits > 0) {
            this.dynSemaphore.release(permits);
        } else {
            this.dynSemaphore.reducePermits(permits *= -1);
        }
        this.maxSize = newMaxSize;
    }

    private void initializeStrategy(String strategyClass) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addResource(ResourceAllocator allocator, int count) throws PoolingException {
        int numResAdded = 0;
        for (int i = 0; i < count && this.resources.size() < this.maxSize; ++i) {
            boolean lockAcquired = this.dynSemaphore.tryAcquire();
            if (!lockAcquired) continue;
            try {
                ResourceHandle handle = this.handler.createResource(allocator);
                ArrayList<ResourceHandle> arrayList = this.resources;
                synchronized (arrayList) {
                    ArrayList<ResourceHandle> arrayList2 = this.free;
                    synchronized (arrayList2) {
                        this.free.add(handle);
                        this.resources.add(handle);
                        ++numResAdded;
                    }
                }
            }
            catch (Exception e) {
                this.dynSemaphore.release();
                PoolingException pe = new PoolingException(e.getMessage());
                pe.initCause((Throwable)e);
                throw pe;
            }
        }
        return numResAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceHandle getResource() {
        ResourceHandle resource = null;
        if (this.strategy != null) {
            resource = this.strategy.retrieveResource();
        } else {
            ArrayList<ResourceHandle> arrayList = this.free;
            synchronized (arrayList) {
                if (this.free.size() > 0) {
                    resource = this.free.remove(0);
                }
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResource(ResourceHandle resource) {
        boolean removed = false;
        ArrayList<ResourceHandle> arrayList = this.resources;
        synchronized (arrayList) {
            ArrayList<ResourceHandle> arrayList2 = this.free;
            synchronized (arrayList2) {
                this.free.remove(resource);
                removed = this.resources.remove(resource);
            }
        }
        if (removed) {
            this.dynSemaphore.release();
            this.handler.deleteResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnResource(ResourceHandle resource) {
        ArrayList<ResourceHandle> arrayList = this.free;
        synchronized (arrayList) {
            this.free.add(resource);
        }
    }

    @Override
    public int getFreeListSize() {
        return this.free.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        ArrayList<ResourceHandle> arrayList = this.resources;
        synchronized (arrayList) {
            ArrayList<ResourceHandle> arrayList2 = this.free;
            synchronized (arrayList2) {
                while (this.resources.size() > 0) {
                    ResourceHandle handle = this.resources.remove(0);
                    this.free.remove(handle);
                    this.dynSemaphore.release();
                    this.handler.deleteResource(handle);
                }
            }
        }
        this.free.clear();
        this.resources.clear();
    }

    @Override
    public int getResourcesSize() {
        return this.resources.size();
    }

    @Override
    public ArrayList<ResourceHandle> getAllResources() {
        return this.resources;
    }

    private static final class DynamicSemaphore
    extends Semaphore {
        DynamicSemaphore() {
            super(0);
        }

        @Override
        protected void reducePermits(int size) {
            super.reducePermits(size);
        }
    }
}

