/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.web.context.http;

import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.logging.ConversationLogger;
import org.jboss.weld.module.web.context.http.HttpConversationContextImpl;
import org.jboss.weld.module.web.servlet.ConversationContextActivator;

public class LazyHttpConversationContextImpl
extends HttpConversationContextImpl {
    private final ThreadLocal<Consumer<HttpServletRequest>> transientConversationInitializationCallback;
    private final ThreadLocal<Object> initialized = new ThreadLocal();

    public LazyHttpConversationContextImpl(String contextId, ServiceRegistry services) {
        super(contextId, services);
        this.transientConversationInitializationCallback = new ThreadLocal();
    }

    @Override
    public void activateLazily(Consumer<HttpServletRequest> transientConversationInitializationCallback) {
        this.activate();
        this.transientConversationInitializationCallback.set(transientConversationInitializationCallback);
    }

    @Override
    public void activate() {
        if (!this.isAssociated()) {
            throw ConversationLogger.LOG.mustCallAssociateBeforeActivate();
        }
        if (!this.isActive()) {
            super.setActive(true);
        } else {
            ConversationLogger.LOG.contextAlreadyActive(this.getRequest());
        }
        this.initialized.set(null);
    }

    public boolean isInitialized() {
        return this.initialized.get() != null;
    }

    @Override
    protected void initialize(String cid) {
        this.initialized.set(Boolean.TRUE);
        super.initialize(cid);
    }

    @Override
    public void deactivate() {
        block7: {
            try {
                if (this.isInitialized()) {
                    try {
                        super.deactivate();
                        break block7;
                    }
                    finally {
                        this.initialized.set(null);
                    }
                }
                this.removeState();
            }
            finally {
                this.transientConversationInitializationCallback.set(null);
            }
        }
    }

    @Override
    public boolean destroy(HttpSession session) {
        if (this.isAssociated()) {
            this.checkContextInitialized();
        }
        return super.destroy(session);
    }

    @Override
    protected void checkContextInitialized() {
        if (!this.isInitialized()) {
            Consumer<HttpServletRequest> callback;
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            String cid = ConversationContextActivator.determineConversationId(request, this.getParameterName());
            this.initialize(cid);
            if (cid == null && (callback = this.transientConversationInitializationCallback.get()) != null) {
                callback.accept(request);
            }
        }
    }
}

