/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CommandRunnerImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class InserverCommandRunnerHelper {
    public static final Logger logger = KernelLoggerInfo.getLogger();
    public static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(InserverCommandRunnerHelper.class);
    @Inject
    private CommandRunnerImpl commandRunner;

    public ActionReport runCommand(String command, ParameterMap parameters, ActionReport report, Subject subject) {
        try {
            AdminCommand adminCommand = this.commandRunner.getCommand(command, report, logger);
            if (adminCommand == null) {
                if (report.getActionExitCode() == ActionReport.ExitCode.FAILURE) {
                    return report;
                }
                String message = adminStrings.getLocalString("adapter.command.notfound", "Command {0} not found", new Object[]{command});
                logger.log(Level.FINE, message);
                report.setMessage(message);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return report;
            }
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation(command, report, subject);
            inv.parameters(parameters).execute();
        }
        catch (Throwable t) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(t);
            report.setMessage(t.getLocalizedMessage());
            report.setActionDescription("Last-chance exception handler");
        }
        return report;
    }
}

