/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloFunction;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.ReferenceLookup;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class Struct
extends GoloElement {
    public static final String IMMUTABLE_FACTORY_METHOD = "$_immutable";
    private PackageAndClass moduleName;
    private final String name;
    private final Set<String> members = new LinkedHashSet<String>();
    private final Set<String> publicMembers = new LinkedHashSet<String>();

    @Override
    public Struct ofAST(GoloASTNode node) {
        super.ofAST(node);
        return this;
    }

    Struct(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Struct members(String ... members) {
        return this.members(Arrays.asList(members));
    }

    public Struct members(Collection<String> members) {
        for (String member : members) {
            this.addMember(member);
        }
        return this;
    }

    public void addMember(String name) {
        this.members.add(name);
        if (!name.startsWith("_")) {
            this.publicMembers.add(name);
        }
    }

    public PackageAndClass getPackageAndClass() {
        return new PackageAndClass(this.moduleName.toString() + ".types", this.name);
    }

    public void setModuleName(PackageAndClass module) {
        this.moduleName = module;
    }

    public Set<String> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    public Set<String> getPublicMembers() {
        return Collections.unmodifiableSet(this.publicMembers);
    }

    public Set<GoloFunction> createFactories() {
        String fullName = this.getPackageAndClass().toString();
        return new LinkedHashSet<GoloFunction>(Arrays.asList(Builders.functionDeclaration(this.name).synthetic().block(Builders.returns(Builders.call(fullName))), Builders.functionDeclaration(this.name).synthetic().withParameters(this.members).block(Builders.returns(Builders.call(fullName).withArgs(this.members.stream().map(ReferenceLookup::new).toArray()))), Builders.functionDeclaration("Immutable" + this.name).synthetic().withParameters(this.members).block(Builders.returns(Builders.call(fullName + "." + IMMUTABLE_FACTORY_METHOD).withArgs(this.members.stream().map(ReferenceLookup::new).toArray())))));
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitStruct(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        throw this.cantReplace();
    }
}

