/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import java.util.Arrays;
import java.util.Iterator;

public class PrimitiveArrayIterator
implements Iterator<Object> {
    private final Object[] array;
    private int position = 0;

    public PrimitiveArrayIterator(Object[] array) {
        this.array = array == null ? new Object[0] : Arrays.copyOf(array, array.length);
    }

    @Override
    public boolean hasNext() {
        return this.position < this.array.length;
    }

    @Override
    public Object next() {
        if (this.hasNext()) {
            return this.array[this.position++];
        }
        throw new ArrayIndexOutOfBoundsException(this.position);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

