/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import gololang.FunctionReference;
import gololang.HeadTail;
import gololang.HeadTailIterator;
import gololang.Tuple;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class LazyList
implements Collection<Object>,
HeadTail<Object> {
    public static final LazyList EMPTY = new LazyList(null, null){

        @Override
        public boolean equals(Object other) {
            return other == this;
        }

        @Override
        public int hashCode() {
            return Objects.hash(null, null);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public LazyList tail() {
            return this;
        }

        @Override
        public String toString() {
            return "LazyList.EMPTY";
        }
    };
    private final Object head;
    private final FunctionReference tail;
    private LazyList memoTail = null;

    public static LazyList cons(Object head, FunctionReference tail) {
        if (tail == null) {
            throw new IllegalArgumentException("Use the empty list instead of null as the last element of a LazyList");
        }
        return new LazyList(head, tail);
    }

    private LazyList(Object head, FunctionReference tail) {
        this.head = head;
        this.tail = tail;
    }

    @Override
    public Object head() {
        return this.head;
    }

    public LazyList tail() {
        if (this.memoTail == null) {
            try {
                this.memoTail = (LazyList)this.tail.invoke(new Object[0]);
            }
            catch (Throwable e) {
                this.memoTail = EMPTY;
            }
        }
        return this.memoTail;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<Object> iterator() {
        return new HeadTailIterator<Object>(this);
    }

    public List<Object> asList() {
        LinkedList<Object> lst = new LinkedList<Object>();
        for (Object o : this) {
            lst.add(o);
        }
        return lst;
    }

    @Override
    public int size() {
        return 1 + this.tail().size();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof LazyList)) {
            return false;
        }
        LazyList other = (LazyList)o;
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (!this.head.equals(other.head)) {
            return false;
        }
        if (this.tail.equals(other.tail)) {
            return true;
        }
        return this.tail().equals(other.tail());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.head, this.tail());
    }

    @Override
    public Object[] toArray() {
        return this.asList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.asList().toArray(a);
    }

    public Tuple destruct() {
        return new Tuple(this.head(), this.tail());
    }

    public Object get(int index) {
        if (index < 0 || this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        if (index == 0) {
            return this.head();
        }
        return this.tail().get(index - 1);
    }

    public int indexOf(Object o) {
        int idx = 0;
        for (Object elt : this) {
            if (elt.equals(o)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object elt : c) {
            if (this.contains(elt)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("LazyList<head=%s, tail=%s>", this.head, this.tail);
    }

    @Override
    public boolean add(Object e) {
        throw new UnsupportedOperationException("a LazyList is immutable");
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException("a LazyList is immutable");
    }

    @Override
    public boolean addAll(Collection<?> c) {
        throw new UnsupportedOperationException("a LazyList is immutable");
    }

    public boolean addAll(int index, Collection<?> c) {
        throw new UnsupportedOperationException("a LazyList is immutable");
    }

    @Override
    public boolean remove(Object e) {
        throw new UnsupportedOperationException("a LazyList is immutable");
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException("a LazyList is immutable");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("a LazyList is immutable");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("a LazyList is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("a LazyList is immutable");
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException("a LazyList is immutable");
    }
}

