/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime.augmentation;

import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.golo.runtime.Loader;
import org.eclipse.golo.runtime.Module;
import org.eclipse.golo.runtime.augmentation.AugmentationApplication;

public final class DefiningModule {
    private final Class<?> module;
    private final Scope scope;

    DefiningModule(Class<?> module, Scope scope) {
        this.module = module;
        this.scope = scope;
    }

    public Class<?> module() {
        return this.module;
    }

    public static DefiningModule of(Class<?> module, Scope scope) {
        return new DefiningModule(module, scope);
    }

    public static DefiningModule ofLocal(Class<?> module) {
        return new DefiningModule(module, Scope.LOCAL);
    }

    public static DefiningModule ofImport(Class<?> module) {
        return new DefiningModule(module, Scope.IMPORT);
    }

    public static DefiningModule ofCallstack(Class<?> module) {
        return new DefiningModule(module, Scope.CALLSTACK);
    }

    private Stream<AugmentationApplication> simpleAugmentationsFor(Loader loader, Class<?> receiverType) {
        return Stream.of(Module.augmentations(this.module)).map(loader).filter(DefiningModule.isAssignableFrom(receiverType)).map(target -> new AugmentationApplication(loader.load(this.module.getName() + "$" + target.getName().replace(".", "$")), (Class<?>)target, this.scope, AugmentationApplication.Kind.SIMPLE));
    }

    private static Predicate<Class<?>> isAssignableFrom(Class<?> receiver) {
        return target -> target != null && target.isAssignableFrom(receiver);
    }

    private Stream<AugmentationApplication> fullyNamedAugmentationsFor(Loader loader, Class<?> receiverType) {
        return Stream.of(Module.augmentationApplications(this.module)).map(targetName -> loader.load((String)targetName)).filter(target -> target != null && target.isAssignableFrom(receiverType)).flatMap(target -> this.qualifyAugmentations(loader, (Class<?>)target));
    }

    private Stream<AugmentationApplication> qualifyAugmentations(Loader loader, Class<?> target) {
        return Stream.of(Module.augmentationApplications(this.module, target)).flatMap(augmentName -> this.fullyQualifiedName((String)augmentName)).map(augmentName -> new AugmentationApplication(loader.load((String)augmentName), target, this.scope, AugmentationApplication.Kind.NAMED));
    }

    private Stream<String> fullyQualifiedName(String augmentationName) {
        Stream.Builder<String> names = Stream.builder();
        int idx = augmentationName.lastIndexOf(".");
        if (idx == -1) {
            names.add(augmentationName);
        } else {
            names.add(new StringBuilder(augmentationName).replace(idx, idx + 1, "$").toString());
        }
        names.add(this.module.getName() + "$" + augmentationName.replace(".", "$"));
        return Stream.concat(names.build(), Stream.of(Module.imports(this.module)).map(prefix -> prefix + "$" + augmentationName.replace(".", "$")));
    }

    public Stream<AugmentationApplication> augmentationsFor(Loader loader, Class<?> receiverType) {
        if (this.module == null) {
            return Stream.empty();
        }
        return Stream.concat(this.simpleAugmentationsFor(loader, receiverType), this.fullyNamedAugmentationsFor(loader, receiverType));
    }

    public String toString() {
        return "DefiningModule<" + this.module + "," + (Object)((Object)this.scope) + ">";
    }

    public static enum Scope {
        LOCAL,
        IMPORT,
        CALLSTACK;

    }
}

