/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command.spi;

import gololang.Messages;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.eclipse.golo.compiler.GoloCompilationException;

public interface CliCommand {
    public static final boolean DEBUG = Boolean.valueOf(System.getProperty("golo.debug", "false"));
    public static final boolean SHOW_TRACE = Boolean.valueOf(System.getProperty("golo.debug.trace", "true"));

    public void execute() throws Throwable;

    default public URLClassLoader primaryClassLoader(List<String> classpath) throws MalformedURLException {
        URL[] urls = new URL[classpath.size()];
        int index = 0;
        for (String element : classpath) {
            urls[index] = new File(element).toURI().toURL();
            ++index;
        }
        return new URLClassLoader(urls);
    }

    default public void callRun(Class<?> klass, String[] arguments) throws Throwable {
        MethodHandle main;
        try {
            main = MethodHandles.publicLookup().findStatic(klass, "main", MethodType.methodType(Void.TYPE, String[].class));
        }
        catch (NoSuchMethodException e) {
            throw new NoMainMethodException().initCause(e);
        }
        main.invoke(arguments);
    }

    default public void handleCompilationException(GoloCompilationException e) {
        this.handleCompilationException(e, true);
    }

    default public void handleCompilationException(GoloCompilationException e, boolean exit) {
        this.handleThrowable(e, false);
        for (GoloCompilationException.Problem problem : e.getProblems()) {
            Messages.error(problem.getDescription());
        }
        if (exit) {
            System.exit(1);
        }
    }

    default public void handleThrowable(Throwable e) {
        this.handleThrowable(e, true);
    }

    default public void handleThrowable(Throwable e, boolean exit) {
        Messages.error(e);
        if (e.getCause() != null) {
            Messages.error(e.getCause().getMessage());
        }
        if (DEBUG || SHOW_TRACE) {
            Messages.printStackTrace(e);
        }
        if (exit) {
            System.exit(1);
        }
    }

    public static class NoMainMethodException
    extends NoSuchMethodException {
    }
}

