/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Objects;
import org.eclipse.golo.compiler.ir.AssignmentStatement;
import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.BlockContainer;
import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.ReferencesHolder;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class LoopStatement
extends GoloStatement
implements BlockContainer,
ReferencesHolder {
    private AssignmentStatement initStatement = null;
    private ExpressionStatement conditionStatement = Builders.constant(false);
    private GoloStatement postStatement = null;
    private Block block = Block.emptyBlock();

    LoopStatement() {
    }

    @Override
    public LoopStatement ofAST(GoloASTNode node) {
        super.ofAST(node);
        return this;
    }

    public LoopStatement init(Object assignment) {
        if (assignment instanceof AssignmentStatement) {
            this.setInitStatement((AssignmentStatement)assignment);
            return this;
        }
        throw LoopStatement.cantConvert("assignment", assignment);
    }

    public LoopStatement condition(Object expression) {
        if (expression instanceof ExpressionStatement) {
            this.setConditionStatement((ExpressionStatement)expression);
            return this;
        }
        throw LoopStatement.cantConvert("expression", expression);
    }

    public LoopStatement post(Object statement) {
        if (statement instanceof GoloStatement) {
            this.setPostStatement((GoloStatement)statement);
            return this;
        }
        throw LoopStatement.cantConvert("statement", statement);
    }

    public LoopStatement block(Block innerBlock) {
        this.setBlock(innerBlock);
        return this;
    }

    public LoopStatement block(Object ... statements) {
        return this.block(Builders.block(statements));
    }

    public boolean hasInitStatement() {
        return this.initStatement != null;
    }

    public AssignmentStatement getInitStatement() {
        return this.initStatement;
    }

    public void setInitStatement(AssignmentStatement init) {
        this.initStatement = init;
        this.makeParentOf(init);
    }

    public ExpressionStatement getConditionStatement() {
        return this.conditionStatement;
    }

    public void setConditionStatement(ExpressionStatement cond) {
        this.conditionStatement = cond == null ? Builders.constant(false) : cond;
        this.makeParentOf(this.conditionStatement);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        this.block = block == null ? Block.emptyBlock() : block;
        this.makeParentOf(this.block);
    }

    public GoloStatement getPostStatement() {
        return this.postStatement;
    }

    public void setPostStatement(GoloStatement stat) {
        this.postStatement = stat;
        this.makeParentOf(this.postStatement);
    }

    public boolean hasPostStatement() {
        return this.postStatement != null;
    }

    @Override
    public LocalReference[] getReferences() {
        if (this.hasInitStatement()) {
            return new LocalReference[]{this.getInitStatement().getLocalReference()};
        }
        return new LocalReference[0];
    }

    @Override
    public int getReferencesCount() {
        return this.hasInitStatement() ? 1 : 0;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitLoopStatement(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        if (this.initStatement != null) {
            this.initStatement.accept(visitor);
        }
        this.conditionStatement.accept(visitor);
        if (this.postStatement != null) {
            this.postStatement.accept(visitor);
        }
        this.block.accept(visitor);
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (Objects.equals(this.initStatement, original)) {
            this.init(newElement);
        } else if (Objects.equals(this.conditionStatement, original)) {
            this.condition(newElement);
        } else if (Objects.equals(this.postStatement, original)) {
            this.post(newElement);
        } else if (Objects.equals(this.block, original)) {
            this.block((Block)newElement);
        } else {
            throw this.cantReplace(original, newElement);
        }
    }
}

