/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import gololang.FunctionReference;
import gololang.Messages;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.golo.runtime.DecoratorsHelper;
import org.eclipse.golo.runtime.Extractors;
import org.eclipse.golo.runtime.Module;
import org.eclipse.golo.runtime.NamedArgumentsHelper;
import org.eclipse.golo.runtime.TypeMatching;
import org.eclipse.golo.runtime.Warnings;
import org.eclipse.golo.runtime.WithCaller;

public final class FunctionCallSupport {
    private static final MethodHandle FALLBACK;
    private static final MethodHandle SAM_FILTER;
    private static final MethodHandle FUNCTIONAL_INTERFACE_FILTER;

    private FunctionCallSupport() {
        throw new UnsupportedOperationException("Don't instantiate invokedynamic bootstrap class");
    }

    public static Object samFilter(Class<?> type, Object value) {
        if (value instanceof FunctionReference) {
            return MethodHandleProxies.asInterfaceInstance(type, ((FunctionReference)value).handle());
        }
        return value;
    }

    public static Object functionalInterfaceFilter(MethodHandles.Lookup caller, Class<?> type, Object value) throws Throwable {
        if (value instanceof FunctionReference) {
            return FunctionCallSupport.asFunctionalInterface(caller, type, ((FunctionReference)value).handle());
        }
        return value;
    }

    public static Object asFunctionalInterface(MethodHandles.Lookup caller, Class<?> type, MethodHandle handle) throws Throwable {
        for (Method method : type.getMethods()) {
            if (method.isDefault() || Modifier.isStatic(method.getModifiers())) continue;
            MethodType lambdaType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
            CallSite callSite = LambdaMetafactory.metafactory(caller, method.getName(), MethodType.methodType(type), lambdaType, handle, lambdaType);
            return callSite.dynamicInvoker().invoke();
        }
        throw new RuntimeException(Messages.message("handle_conversion_failed", handle, type));
    }

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type, Object ... bsmArgs) throws IllegalAccessException, ClassNotFoundException {
        boolean constant = (Integer)bsmArgs[0] == 1;
        String[] argumentNames = new String[bsmArgs.length - 1];
        for (int i = 0; i < bsmArgs.length - 1; ++i) {
            argumentNames[i] = (String)bsmArgs[i + 1];
        }
        FunctionCallSite callSite = new FunctionCallSite(caller, name.replaceAll("#", "\\."), type, constant, argumentNames);
        MethodHandle fallbackHandle = FALLBACK.bindTo(callSite).asCollector(Object[].class, type.parameterCount()).asType(type);
        callSite.setTarget(fallbackHandle);
        return callSite;
    }

    public static Object fallback(FunctionCallSite callSite, Object[] args) throws Throwable {
        String functionName = callSite.name;
        MethodType type = callSite.type();
        MethodHandles.Lookup caller = callSite.callerLookup;
        Class<?> callerClass = caller.lookupClass();
        String[] argumentNames = callSite.argumentNames;
        MethodHandle handle = null;
        AccessibleObject result = FunctionCallSupport.findStaticMethodOrField(callerClass, callerClass, functionName, args);
        if (result == null) {
            result = FunctionCallSupport.findClassWithStaticMethodOrField(callerClass, functionName, args);
        }
        if (result == null) {
            result = FunctionCallSupport.findClassWithStaticMethodOrFieldFromImports(callerClass, functionName, args);
        }
        if (result == null) {
            result = FunctionCallSupport.findClassWithConstructor(callerClass, functionName, args);
        }
        if (result == null) {
            result = FunctionCallSupport.findClassWithConstructorFromImports(callerClass, functionName, args);
        }
        if (result == null) {
            throw new NoSuchMethodError(functionName + type.toMethodDescriptorString());
        }
        Class<?>[] types2 = null;
        if (result instanceof Method) {
            Method method = (Method)result;
            FunctionCallSupport.checkLocalFunctionCallFromSameModuleAugmentation(method, callerClass.getName());
            if (DecoratorsHelper.isMethodDecorated(method)) {
                handle = DecoratorsHelper.getDecoratedMethodHandle(caller, method, type.parameterCount());
            } else {
                types2 = method.getParameterTypes();
                handle = caller.unreflect(method);
                if (method.isAnnotationPresent(WithCaller.class)) {
                    handle = handle.bindTo(callerClass);
                }
                handle = FunctionCallSupport.isVarargsWithNames(method, types2, args, argumentNames) ? handle.asFixedArity().asType(type) : handle.asType(type);
            }
            handle = FunctionCallSupport.reorderArguments(method, handle, argumentNames);
        } else if (result instanceof Constructor) {
            Constructor constructor = (Constructor)result;
            types2 = constructor.getParameterTypes();
            handle = constructor.isVarArgs() && TypeMatching.isLastArgumentAnArray(types2.length, args) ? caller.unreflectConstructor(constructor).asFixedArity().asType(type) : caller.unreflectConstructor(constructor).asType(type);
        } else {
            Field field = (Field)result;
            handle = caller.unreflectGetter(field).asType(type);
        }
        handle = FunctionCallSupport.insertSAMFilter(handle, callSite.callerLookup, types2, 0);
        if (callSite.constant) {
            Object constantValue = handle.invokeWithArguments(args);
            MethodHandle constant = constantValue == null ? MethodHandles.constant(Object.class, null) : MethodHandles.constant(constantValue.getClass(), constantValue);
            constant = MethodHandles.dropArguments(constant, 0, type.parameterArray());
            callSite.setTarget(constant.asType(type));
            return constantValue;
        }
        callSite.setTarget(handle);
        return handle.invokeWithArguments(args);
    }

    private static boolean isVarargsWithNames(Method method, Class<?>[] types2, Object[] args, String[] argumentNames) {
        return method.isVarArgs() && (TypeMatching.isLastArgumentAnArray(types2.length, args) || argumentNames.length > 0);
    }

    private static int[] getArgumentsOrder(Method method, List<String> parameterNames, String[] argumentNames) {
        int[] argumentsOrder = new int[parameterNames.size()];
        int i = 0;
        while (i < argumentNames.length) {
            int actualPosition = parameterNames.indexOf(argumentNames[i]);
            NamedArgumentsHelper.checkArgumentPosition(actualPosition, argumentNames[i], method.getName() + parameterNames);
            argumentsOrder[actualPosition] = i++;
        }
        return argumentsOrder;
    }

    public static MethodHandle reorderArguments(Method method, MethodHandle handle, String[] argumentNames) {
        if (argumentNames.length == 0) {
            return handle;
        }
        if (NamedArgumentsHelper.hasNamedParameters(method).booleanValue()) {
            return MethodHandles.permuteArguments(handle, handle.type(), FunctionCallSupport.getArgumentsOrder(method, NamedArgumentsHelper.getParameterNames(method), argumentNames));
        }
        Warnings.noParameterNames(method.getName(), argumentNames);
        return handle;
    }

    public static MethodHandle insertSAMFilter(MethodHandle handle, MethodHandles.Lookup caller, Class<?>[] types2, int startIndex) {
        if (types2 != null) {
            for (int i = 0; i < types2.length; ++i) {
                if (TypeMatching.isSAM(types2[i])) {
                    handle = MethodHandles.filterArguments(handle, startIndex + i, SAM_FILTER.bindTo(types2[i]));
                    continue;
                }
                if (!TypeMatching.isFunctionalInterface(types2[i])) continue;
                handle = MethodHandles.filterArguments(handle, startIndex + i, FUNCTIONAL_INTERFACE_FILTER.bindTo(caller).bindTo(types2[i]));
            }
        }
        return handle;
    }

    private static void checkLocalFunctionCallFromSameModuleAugmentation(Method method, String callerClassName) {
        if (Modifier.isPrivate(method.getModifiers()) && callerClassName.contains("$")) {
            String prefix = callerClassName.substring(0, callerClassName.indexOf("$"));
            if (method.getDeclaringClass().getName().equals(prefix)) {
                method.setAccessible(true);
            }
        }
    }

    private static AccessibleObject findClassWithConstructorFromImports(Class<?> callerClass, String classname, Object[] args) {
        String[] imports;
        for (String imported : imports = Module.imports(callerClass)) {
            AccessibleObject result = FunctionCallSupport.findClassWithConstructor(callerClass, imported + "." + classname, args);
            if (result != null) {
                return result;
            }
            if (!imported.endsWith(classname) || (result = FunctionCallSupport.findClassWithConstructor(callerClass, imported, args)) == null) continue;
            return result;
        }
        return null;
    }

    private static AccessibleObject findClassWithConstructor(Class<?> callerClass, String classname, Object[] args) {
        try {
            Class<?> targetClass = Class.forName(classname, true, callerClass.getClassLoader());
            for (Constructor<?> constructor : targetClass.getConstructors()) {
                if (!TypeMatching.argumentsMatch(constructor, args)) continue;
                return Extractors.checkDeprecation(callerClass, constructor);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private static AccessibleObject findClassWithStaticMethodOrFieldFromImports(Class<?> callerClass, String functionName, Object[] args) {
        String[] imports = Module.imports(callerClass);
        String[] classAndMethod = null;
        int classAndMethodSeparator = functionName.lastIndexOf(".");
        if (classAndMethodSeparator > 0) {
            classAndMethod = new String[]{functionName.substring(0, classAndMethodSeparator), functionName.substring(classAndMethodSeparator + 1)};
        }
        for (String importedClassName : imports) {
            try {
                Class<?> importedClass;
                try {
                    importedClass = Class.forName(importedClassName, true, callerClass.getClassLoader());
                }
                catch (ClassNotFoundException expected) {
                    if (classAndMethod == null) {
                        throw expected;
                    }
                    importedClass = Class.forName(importedClassName + "." + classAndMethod[0], true, callerClass.getClassLoader());
                }
                String lookup = classAndMethod == null ? functionName : classAndMethod[1];
                AccessibleObject result = FunctionCallSupport.findStaticMethodOrField(callerClass, importedClass, lookup, args);
                if (result == null) continue;
                return result;
            }
            catch (ClassNotFoundException ignored) {
                Warnings.unavailableClass(importedClassName, callerClass.getName());
            }
        }
        return null;
    }

    private static AccessibleObject findClassWithStaticMethodOrField(Class<?> callerClass, String functionName, Object[] args) {
        int methodClassSeparatorIndex = functionName.lastIndexOf(".");
        if (methodClassSeparatorIndex >= 0) {
            String className = functionName.substring(0, methodClassSeparatorIndex);
            String methodName = functionName.substring(methodClassSeparatorIndex + 1);
            try {
                Class<?> targetClass = Class.forName(className, true, callerClass.getClassLoader());
                return FunctionCallSupport.findStaticMethodOrField(callerClass, targetClass, methodName, args);
            }
            catch (ClassNotFoundException ignored) {
                Warnings.unavailableClass(className, callerClass.getName());
            }
        }
        return null;
    }

    private static AccessibleObject findStaticMethodOrField(Class<?> caller, Class<?> klass, String name, Object[] arguments) {
        for (Method method : klass.getDeclaredMethods()) {
            if (!FunctionCallSupport.methodMatches(caller, name, arguments, method, false)) continue;
            return Extractors.checkDeprecation(caller, method);
        }
        for (Method method : klass.getMethods()) {
            if (!FunctionCallSupport.methodMatches(caller, name, arguments, method, false)) continue;
            return Extractors.checkDeprecation(caller, method);
        }
        for (Method method : klass.getDeclaredMethods()) {
            if (!FunctionCallSupport.methodMatches(caller, name, arguments, method, true)) continue;
            return Extractors.checkDeprecation(caller, method);
        }
        for (Method method : klass.getMethods()) {
            if (!FunctionCallSupport.methodMatches(caller, name, arguments, method, true)) continue;
            return Extractors.checkDeprecation(caller, method);
        }
        if (arguments.length == 0) {
            for (AccessibleObject accessibleObject : klass.getDeclaredFields()) {
                if (!FunctionCallSupport.fieldMatches(name, (Field)accessibleObject)) continue;
                return Extractors.checkDeprecation(caller, accessibleObject);
            }
            for (AccessibleObject accessibleObject : klass.getFields()) {
                if (!FunctionCallSupport.fieldMatches(name, (Field)accessibleObject)) continue;
                return Extractors.checkDeprecation(caller, accessibleObject);
            }
        }
        return null;
    }

    private static boolean methodMatches(Class<?> caller, String name, Object[] arguments, Method method, boolean varargs) {
        return FunctionCallSupport.methodMatches(caller, name, arguments, method, varargs, true);
    }

    private static boolean methodMatches(Class<?> caller, String name, Object[] arguments, Method method, boolean varargs, boolean tryCaller) {
        if (!method.getName().equals(name) || !Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (DecoratorsHelper.isMethodDecorated(method)) {
            return true;
        }
        if (TypeMatching.argumentsMatch(method, arguments, varargs)) {
            return true;
        }
        if (method.isAnnotationPresent(WithCaller.class) && tryCaller) {
            Object[] argsWithCaller = new Object[arguments.length + 1];
            argsWithCaller[0] = caller;
            System.arraycopy(arguments, 0, argsWithCaller, 1, arguments.length);
            return FunctionCallSupport.methodMatches(caller, name, argsWithCaller, method, varargs, false);
        }
        return false;
    }

    private static boolean fieldMatches(String name, Field field) {
        return field.getName().equals(name) && Modifier.isStatic(field.getModifiers());
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            FALLBACK = lookup.findStatic(FunctionCallSupport.class, "fallback", MethodType.methodType(Object.class, FunctionCallSite.class, Object[].class));
            SAM_FILTER = lookup.findStatic(FunctionCallSupport.class, "samFilter", MethodType.methodType(Object.class, Class.class, Object.class));
            FUNCTIONAL_INTERFACE_FILTER = lookup.findStatic(FunctionCallSupport.class, "functionalInterfaceFilter", MethodType.methodType(Object.class, MethodHandles.Lookup.class, Class.class, Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error("Could not bootstrap the required method handles", e);
        }
    }

    static class FunctionCallSite
    extends MutableCallSite {
        final MethodHandles.Lookup callerLookup;
        final String name;
        final boolean constant;
        final String[] argumentNames;

        FunctionCallSite(MethodHandles.Lookup callerLookup, String name, MethodType type, boolean constant, String ... argumentNames) {
            super(type);
            this.callerLookup = callerLookup;
            this.name = name;
            this.constant = constant;
            this.argumentNames = argumentNames;
        }
    }
}

