/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.vertx;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.Optional;

public class ContextLocals {
    private ContextLocals() {
    }

    private static Context ensureDuplicatedContext() {
        Context current = Vertx.currentContext();
        if (current == null || !VertxContext.isDuplicatedContext(current)) {
            throw new UnsupportedOperationException("Access to Context Locals are forbidden from a 'root' context  as it can leak data between unrelated processing. Make sure the method runs on a 'duplicated' (local) Context");
        }
        return current;
    }

    public static <T> Optional<T> get(String key) {
        Context current = ContextLocals.ensureDuplicatedContext();
        return Optional.ofNullable(current.getLocal(Assert.checkNotNullParam("key", key)));
    }

    public static <T> T get(String key, T def) {
        Context current = ContextLocals.ensureDuplicatedContext();
        Object local = current.getLocal(Assert.checkNotNullParam("key", key));
        if (local == null) {
            return def;
        }
        return local;
    }

    public static <T> void put(String key, T value) {
        Context current = ContextLocals.ensureDuplicatedContext();
        current.putLocal(Assert.checkNotNullParam("key", key), Assert.checkNotNullParam("value", value));
    }

    public static boolean remove(String key) {
        Context current = ContextLocals.ensureDuplicatedContext();
        return current.removeLocal(Assert.checkNotNullParam("key", key));
    }
}

