/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.config;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PemReader {
    private static final Pattern BEGIN_PATTERN = Pattern.compile("-+BEGIN (.*?)-+");
    private static final Pattern END_PATTERN = Pattern.compile("-+END (.*?)-+");

    private PemReader() {
    }

    public static List<Entry> readAll(Path path) throws IOException {
        Objects.requireNonNull(path);
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.US_ASCII);){
            List<Entry> list = PemReader.readAll(reader);
            return list;
        }
    }

    public static List<Entry> readAllBlocking(Vertx vertx, Path path) throws IOException {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(path);
        return PemReader.readAllFromBuffer(vertx.fileSystem().readFileBlocking(path.toString()));
    }

    private static List<Entry> readAllFromBuffer(Buffer buffer) throws IOException {
        String string = buffer.toString(StandardCharsets.US_ASCII);
        return PemReader.readAll(new StringReader(string));
    }

    public static void readAll(Vertx vertx, Path path, Handler<AsyncResult<List<Entry>>> handler) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(path);
        Objects.requireNonNull(handler);
        vertx.fileSystem().readFile(path.toString(), reader -> {
            if (reader.failed()) {
                handler.handle(Future.failedFuture(reader.cause()));
            } else {
                try {
                    handler.handle(Future.succeededFuture(PemReader.readAllFromBuffer((Buffer)reader.result())));
                }
                catch (Exception e) {
                    handler.handle(Future.failedFuture(e));
                }
            }
        });
    }

    public static List<Entry> readAll(Reader reader) throws IOException {
        String line;
        LineNumberReader lnr = new LineNumberReader(reader);
        ArrayList<Entry> result = new ArrayList<Entry>();
        String type = null;
        StringBuilder buffer = null;
        while ((line = lnr.readLine()) != null) {
            if (line.isEmpty()) continue;
            Matcher begin = BEGIN_PATTERN.matcher(line);
            if (begin.matches()) {
                if (buffer != null) {
                    throw new IOException("PEM: Duplicate BEGIN statement");
                }
                buffer = new StringBuilder();
                type = begin.group(1);
                continue;
            }
            Matcher end = END_PATTERN.matcher(line);
            if (end.matches()) {
                if (buffer == null) {
                    throw new IOException("PEM: Encountered END without preceding BEGIN statement");
                }
                String endType = end.group(1);
                if (!type.equals(endType)) {
                    throw new IOException(String.format("PEM: END statement mismatches BEGIN statement type (BEGIN: '%s' - END: '%s')", type, endType));
                }
                result.add(new Entry(type, Base64.getMimeDecoder().decode(buffer.toString())));
                buffer = null;
                type = null;
                continue;
            }
            if (buffer != null) {
                buffer.append(line).append('\n');
                continue;
            }
            throw new IOException("PEM: Payload data outside of BEGIN/END block");
        }
        if (buffer != null) {
            throw new IOException("PEM: Missing closing END block after BEGIN when reaching end of file");
        }
        return result;
    }

    public static class Entry {
        private String type;
        private byte[] payload;

        private Entry(String type, byte[] payload) {
            this.type = type;
            this.payload = payload;
        }

        public byte[] getPayload() {
            return this.payload;
        }

        public String getType() {
            return this.type;
        }
    }
}

