/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.JDKSpecific;

@TargetClass(value=JDKSpecific.class)
@Substitute
final class JDKSpecific_Subs {
    JDKSpecific_Subs() {
    }

    @Substitute
    static void calculateCaller(ExtLogRecord logRecord) {
        String loggerClassName = logRecord.getLoggerClassName();
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        boolean found = false;
        for (StackTraceElement element : stackTrace) {
            if (element.getClassName().equals(loggerClassName)) {
                found = true;
                continue;
            }
            if (!found) continue;
            logRecord.setSourceClassName(element.getClassName());
            logRecord.setSourceMethodName(element.getMethodName());
            logRecord.setSourceFileName(element.getFileName());
            logRecord.setSourceLineNumber(element.getLineNumber());
            return;
        }
        logRecord.setUnknownCaller();
    }

    @TargetClass(value=JDKSpecific.GatewayPrivilegedAction.class)
    @Delete
    static final class GatewayPrivilegedAction {
        GatewayPrivilegedAction() {
        }
    }

    @TargetClass(value=JDKSpecific.Gateway.class)
    @Delete
    static final class Gateway {
        Gateway() {
        }
    }
}

