/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.grpc;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import io.micrometer.core.instrument.binder.grpc.GrpcServerObservationContext;
import io.micrometer.observation.Observation;

class ObservationGrpcServerCall<ReqT, RespT>
extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
    private final Observation.Scope scope;

    ObservationGrpcServerCall(ServerCall<ReqT, RespT> delegate, Observation.Scope scope) {
        super(delegate);
        this.scope = scope;
    }

    public void sendMessage(RespT message) {
        this.scope.getCurrentObservation().event(GrpcObservationDocumentation.GrpcServerEvents.MESSAGE_SENT);
        super.sendMessage(message);
    }

    public void close(Status status, Metadata trailers) {
        Observation observation = this.scope.getCurrentObservation();
        if (status.getCause() != null) {
            observation.error(status.getCause());
        }
        GrpcServerObservationContext context = (GrpcServerObservationContext)observation.getContext();
        context.setStatusCode(status.getCode());
        this.scope.close();
        observation.stop();
        super.close(status, trailers);
    }
}

