/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SniCompletionEvent;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Mapping;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;

class VertxSniHandler
extends SniHandler {
    private final long handshakeTimeoutMillis;
    private ScheduledFuture<?> timeoutFuture;

    public VertxSniHandler(Mapping<? super String, ? extends SslContext> mapping, long handshakeTimeoutMillis) {
        super(mapping);
        this.handshakeTimeoutMillis = handshakeTimeoutMillis;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (this.handshakeTimeoutMillis > 0L) {
            assert (ctx.channel().isActive());
            this.timeoutFuture = ctx.executor().schedule(() -> {
                SSLException exception = new SSLException("handshake timed out after " + this.handshakeTimeoutMillis + "ms");
                ctx.fireUserEventTriggered(new SniCompletionEvent(exception));
                ctx.close();
            }, this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        super.handlerAdded(ctx);
    }

    @Override
    protected SslHandler newSslHandler(SslContext context, ByteBufAllocator allocator) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        SslHandler sslHandler = super.newSslHandler(context, allocator);
        sslHandler.setHandshakeTimeout(this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
        return sslHandler;
    }
}

