/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniAwaitOptional;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.uni.UniBlockingAwait;
import java.time.Duration;

public class UniAwait<T> {
    private final Uni<T> upstream;
    private final Context context;

    public UniAwait(Uni<T> upstream, Context context) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
        this.context = context;
    }

    public T indefinitely() {
        return this.atMost(null);
    }

    public T atMost(Duration duration) {
        return UniBlockingAwait.await(this.upstream, duration, this.context);
    }

    @CheckReturnValue
    public UniAwaitOptional<T> asOptional() {
        return new UniAwaitOptional<T>(this.upstream, this.context);
    }
}

