/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.messaging;

import java.util.Collection;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FastPathDescribedTypeConstructor;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.TypeEncoding;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.codec.messaging.PropertiesType;

public class FastPathPropertiesType
implements AMQPType<Properties>,
FastPathDescribedTypeConstructor<Properties> {
    private static final byte DESCRIPTOR_CODE = 115;
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(115L), Symbol.valueOf("amqp:properties:list")};
    private final PropertiesType propertiesType;

    public FastPathPropertiesType(EncoderImpl encoder) {
        this.propertiesType = new PropertiesType(encoder);
    }

    public EncoderImpl getEncoder() {
        return this.propertiesType.getEncoder();
    }

    public DecoderImpl getDecoder() {
        return this.propertiesType.getDecoder();
    }

    @Override
    public Properties readValue() {
        DecoderImpl decoder = this.getDecoder();
        ReadableBuffer buffer = decoder.getBuffer();
        byte typeCode = decoder.getBuffer().get();
        int size = 0;
        int count = 0;
        switch (typeCode) {
            case 69: {
                break;
            }
            case -64: {
                size = buffer.get() & 0xFF;
                count = buffer.get() & 0xFF;
                break;
            }
            case -48: {
                size = buffer.getInt();
                count = buffer.getInt();
                break;
            }
            default: {
                throw new DecodeException("Incorrect type found in Properties encoding: " + typeCode);
            }
        }
        Properties properties = new Properties();
        block20: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    properties.setMessageId(decoder.readObject());
                    continue block20;
                }
                case 1: {
                    properties.setUserId(decoder.readBinary(null));
                    continue block20;
                }
                case 2: {
                    properties.setTo(decoder.readString(null));
                    continue block20;
                }
                case 3: {
                    properties.setSubject(decoder.readString(null));
                    continue block20;
                }
                case 4: {
                    properties.setReplyTo(decoder.readString(null));
                    continue block20;
                }
                case 5: {
                    properties.setCorrelationId(decoder.readObject());
                    continue block20;
                }
                case 6: {
                    properties.setContentType(decoder.readSymbol(null));
                    continue block20;
                }
                case 7: {
                    properties.setContentEncoding(decoder.readSymbol(null));
                    continue block20;
                }
                case 8: {
                    properties.setAbsoluteExpiryTime(decoder.readTimestamp(null));
                    continue block20;
                }
                case 9: {
                    properties.setCreationTime(decoder.readTimestamp(null));
                    continue block20;
                }
                case 10: {
                    properties.setGroupId(decoder.readString(null));
                    continue block20;
                }
                case 11: {
                    properties.setGroupSequence(decoder.readUnsignedInteger(null));
                    continue block20;
                }
                case 12: {
                    properties.setReplyToGroupId(decoder.readString(null));
                    continue block20;
                }
                default: {
                    throw new IllegalStateException("To many entries in Properties encoding");
                }
            }
        }
        return properties;
    }

    @Override
    public void skipValue() {
        this.getDecoder().readConstructor().skipValue();
    }

    @Override
    public boolean encodesJavaPrimitive() {
        return false;
    }

    @Override
    public Class<Properties> getTypeClass() {
        return Properties.class;
    }

    @Override
    public TypeEncoding<Properties> getEncoding(Properties properties) {
        return this.propertiesType.getEncoding(properties);
    }

    @Override
    public TypeEncoding<Properties> getCanonicalEncoding() {
        return this.propertiesType.getCanonicalEncoding();
    }

    @Override
    public Collection<? extends TypeEncoding<Properties>> getAllEncodings() {
        return this.propertiesType.getAllEncodings();
    }

    @Override
    public void write(Properties value) {
        WritableBuffer buffer = this.getEncoder().getBuffer();
        int count = this.getElementCount(value);
        byte encodingCode = this.deduceEncodingCode(value, count);
        buffer.put((byte)0);
        buffer.put((byte)83);
        buffer.put((byte)115);
        buffer.put(encodingCode);
        if (encodingCode == 69) {
            return;
        }
        int fieldWidth = encodingCode == -64 ? 1 : 4;
        int startIndex = buffer.position();
        if (fieldWidth == 1) {
            buffer.put((byte)0);
            buffer.put((byte)count);
        } else {
            buffer.putInt(0);
            buffer.putInt(count);
        }
        for (int i = 0; i < count; ++i) {
            this.writeElement(value, i);
        }
        int endIndex = buffer.position();
        int writeSize = endIndex - startIndex - fieldWidth;
        buffer.position(startIndex);
        if (fieldWidth == 1) {
            buffer.put((byte)writeSize);
        } else {
            buffer.putInt(writeSize);
        }
        buffer.position(endIndex);
    }

    private byte deduceEncodingCode(Properties value, int elementCount) {
        if (elementCount == 0) {
            return 69;
        }
        return -48;
    }

    private void writeElement(Properties properties, int index) {
        switch (index) {
            case 0: {
                this.getEncoder().writeObject(properties.getMessageId());
                break;
            }
            case 1: {
                this.getEncoder().writeBinary(properties.getUserId());
                break;
            }
            case 2: {
                this.getEncoder().writeString(properties.getTo());
                break;
            }
            case 3: {
                this.getEncoder().writeString(properties.getSubject());
                break;
            }
            case 4: {
                this.getEncoder().writeString(properties.getReplyTo());
                break;
            }
            case 5: {
                this.getEncoder().writeObject(properties.getCorrelationId());
                break;
            }
            case 6: {
                this.getEncoder().writeSymbol(properties.getContentType());
                break;
            }
            case 7: {
                this.getEncoder().writeSymbol(properties.getContentEncoding());
                break;
            }
            case 8: {
                this.getEncoder().writeTimestamp(properties.getAbsoluteExpiryTime());
                break;
            }
            case 9: {
                this.getEncoder().writeTimestamp(properties.getCreationTime());
                break;
            }
            case 10: {
                this.getEncoder().writeString(properties.getGroupId());
                break;
            }
            case 11: {
                this.getEncoder().writeUnsignedInteger(properties.getGroupSequence());
                break;
            }
            case 12: {
                this.getEncoder().writeString(properties.getReplyToGroupId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Properties value index: " + index);
            }
        }
    }

    private int getElementCount(Properties properties) {
        if (properties.getReplyToGroupId() != null) {
            return 13;
        }
        if (properties.getGroupSequence() != null) {
            return 12;
        }
        if (properties.getGroupId() != null) {
            return 11;
        }
        if (properties.getCreationTime() != null) {
            return 10;
        }
        if (properties.getAbsoluteExpiryTime() != null) {
            return 9;
        }
        if (properties.getContentEncoding() != null) {
            return 8;
        }
        if (properties.getContentType() != null) {
            return 7;
        }
        if (properties.getCorrelationId() != null) {
            return 6;
        }
        if (properties.getReplyTo() != null) {
            return 5;
        }
        if (properties.getSubject() != null) {
            return 4;
        }
        if (properties.getTo() != null) {
            return 3;
        }
        if (properties.getUserId() != null) {
            return 2;
        }
        if (properties.getMessageId() != null) {
            return 1;
        }
        return 0;
    }

    public static void register(Decoder decoder, EncoderImpl encoder) {
        FastPathPropertiesType type = new FastPathPropertiesType(encoder);
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, type);
        }
        encoder.register(type);
    }
}

