/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ImpersonatorInterceptor
implements Interceptor {
    public static final String IMPERSONATE_USER = "Impersonate-User";
    public static final String NAME = "IMPERSONATOR";
    private final RequestConfig requestConfig;

    public ImpersonatorInterceptor(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    @Override
    public void before(BasicBuilder builder, HttpRequest request, Interceptor.RequestTags tags) {
        RequestConfig config = Optional.ofNullable(tags.getTag(RequestConfig.class)).orElse(this.requestConfig);
        if (Utils.isNotNullOrEmpty(config.getImpersonateUsername())) {
            Map<String, List<String>> impersonateExtras;
            builder.header(IMPERSONATE_USER, config.getImpersonateUsername());
            String[] impersonateGroups = config.getImpersonateGroups();
            if (Utils.isNotNullOrEmpty(impersonateGroups)) {
                for (String string : impersonateGroups) {
                    builder.header("Impersonate-Group", string);
                }
            }
            if (Utils.isNotNullOrEmpty(impersonateExtras = config.getImpersonateExtras())) {
                Set<String> keys = impersonateExtras.keySet();
                for (Object e : keys) {
                    List<String> values = impersonateExtras.get(e);
                    if (values == null) continue;
                    for (String value : values) {
                        builder.header("Impersonate-Extra-" + e, value);
                    }
                }
            }
        }
    }
}

