/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSession;
import io.vertx.ext.web.handler.sockjs.impl.TransportListener;
import io.vertx.ext.web.impl.Origin;

class WebSocketTransport
extends BaseTransport {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketTransport.class);
    private final Origin origin;
    private final Handler<SockJSSocket> sockHandler;

    WebSocketTransport(Vertx vertx, Router router, LocalMap<String, SockJSSession> sessions, SockJSHandlerOptions options, Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, options);
        this.origin = options.getOrigin() != null ? Origin.parse(options.getOrigin()) : null;
        this.sockHandler = sockHandler;
        String wsRE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/websocket";
        router.getWithRegex(wsRE).handler(this::handleGet);
        router.routeWithRegex(wsRE).handler(rc -> rc.response().putHeader(HttpHeaders.ALLOW, (CharSequence)"GET").setStatusCode(405).end());
    }

    private void handleGet(RoutingContext ctx) {
        HttpServerRequest req = ctx.request();
        if (!HttpUtils.canUpgradeToWebSocket(req)) {
            ctx.response().setStatusCode(400);
            ctx.response().end("Can \"Upgrade\" only to \"WebSocket\".");
            return;
        }
        if (!Origin.check(this.origin, ctx)) {
            ctx.fail(403, new VertxException("Invalid Origin", true));
            return;
        }
        req.toWebSocket().onFailure(ctx::fail).onSuccess(socket -> {
            SockJSSession session = new SockJSSession(this.vertx, this.sessions, ctx, this.options, this.sockHandler);
            session.register(req, new WebSocketListener((ServerWebSocket)socket, session));
        });
    }

    private static class WebSocketListener
    implements TransportListener {
        final ServerWebSocket ws;
        final SockJSSession session;
        boolean closed;

        WebSocketListener(ServerWebSocket ws, SockJSSession session) {
            this.ws = ws;
            this.session = session;
            ws.textMessageHandler(this::handleMessages);
            ws.closeHandler(v -> {
                this.closed = true;
                session.shutdown();
            });
            ws.exceptionHandler(t -> {
                this.closed = true;
                session.shutdown();
                session.handleException((Throwable)t);
            });
        }

        private void handleMessages(String msgs) {
            if (!(this.session.isClosed() || msgs.equals("") || msgs.equals("[]"))) {
                if (msgs.startsWith("[\"") && msgs.endsWith("\"]") || msgs.startsWith("\"") && msgs.endsWith("\"")) {
                    this.session.handleMessages(msgs);
                } else {
                    this.close();
                }
            }
        }

        @Override
        public void sendFrame(String body, Handler<AsyncResult<Void>> handler) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("WS, sending frame");
            }
            if (!this.closed) {
                this.ws.writeTextMessage(body, (Handler)handler);
            } else if (handler != null) {
                handler.handle(Future.failedFuture(ConnectionBase.CLOSED_EXCEPTION));
            }
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.ws.close();
                this.session.shutdown();
                this.closed = true;
            }
        }

        @Override
        public void sessionClosed() {
            this.session.writeClosed(this);
            this.closed = true;
            this.session.context().runOnContext(v -> this.ws.close());
        }
    }
}

