/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.mutiny.core.metrics.Measured;
import java.util.concurrent.Callable;

@MutinyGen(value=io.vertx.core.WorkerExecutor.class)
public class WorkerExecutor
implements Measured {
    public static final TypeArg<WorkerExecutor> __TYPE_ARG = new TypeArg<WorkerExecutor>(obj -> new WorkerExecutor((io.vertx.core.WorkerExecutor)obj), WorkerExecutor::getDelegate);
    private final io.vertx.core.WorkerExecutor delegate;

    public WorkerExecutor(io.vertx.core.WorkerExecutor delegate) {
        this.delegate = delegate;
    }

    public WorkerExecutor(Object delegate) {
        this.delegate = (io.vertx.core.WorkerExecutor)delegate;
    }

    WorkerExecutor() {
        this.delegate = null;
    }

    @Override
    public io.vertx.core.WorkerExecutor getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerExecutor that = (WorkerExecutor)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    @CheckReturnValue
    public <T> Uni<T> executeBlocking(final Uni<T> blockingCodeHandler, boolean ordered) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.executeBlocking(new Handler<Promise<T>>(){

            @Override
            public void handle(Promise<T> event) {
                blockingCodeHandler.subscribe().with(it -> event.complete(it), failure -> event.fail((Throwable)failure));
            }
        }, ordered, resultHandler));
    }

    @Deprecated
    public <T> T executeBlockingAndAwait(Uni<T> blockingCodeHandler, boolean ordered) {
        return this.executeBlocking(blockingCodeHandler, ordered).await().indefinitely();
    }

    @Deprecated
    public <T> void executeBlockingAndForget(Uni<T> blockingCodeHandler, boolean ordered) {
        this.executeBlocking(blockingCodeHandler, ordered).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public <T> Uni<T> executeBlocking(final Uni<T> blockingCodeHandler) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.executeBlocking(new Handler<Promise<T>>(){

            @Override
            public void handle(Promise<T> event) {
                blockingCodeHandler.subscribe().with(it -> event.complete(it), failure -> event.fail((Throwable)failure));
            }
        }, resultHandler));
    }

    @Deprecated
    public <T> T executeBlockingAndAwait(Uni<T> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler).await().indefinitely();
    }

    @Deprecated
    public <T> void executeBlockingAndForget(Uni<T> blockingCodeHandler) {
        this.executeBlocking(blockingCodeHandler).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public <T> Uni<T> executeBlocking(Callable<T> blockingCodeHandler) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.executeBlocking(blockingCodeHandler, resultHandler));
    }

    public <T> T executeBlockingAndAwait(Callable<T> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler).await().indefinitely();
    }

    public <T> void executeBlockingAndForget(Callable<T> blockingCodeHandler) {
        this.executeBlocking(blockingCodeHandler).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public <T> Uni<T> executeBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.executeBlocking(blockingCodeHandler, ordered, resultHandler));
    }

    public <T> T executeBlockingAndAwait(Callable<T> blockingCodeHandler, boolean ordered) {
        return this.executeBlocking(blockingCodeHandler, ordered).await().indefinitely();
    }

    public <T> void executeBlockingAndForget(Callable<T> blockingCodeHandler, boolean ordered) {
        this.executeBlocking(blockingCodeHandler, ordered).subscribe().with(UniHelper.NOOP);
    }

    public static WorkerExecutor newInstance(io.vertx.core.WorkerExecutor arg) {
        return arg != null ? new WorkerExecutor(arg) : null;
    }
}

