/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.databinding.runtime.observables;

import java.util.StringTokenizer;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.incquery.databinding.runtime.api.IncQueryObservables;
import org.eclipse.incquery.runtime.api.IPatternMatch;

public class ObservableLabelFeature
extends ComputedValue {
    IPatternMatch match;
    String expression;
    Object container;

    public ObservableLabelFeature(IPatternMatch match, String expression, Object container) {
        super(String.class);
        this.match = match;
        this.expression = expression;
        this.container = container;
    }

    public Object getContainer() {
        return this.container;
    }

    public IPatternMatch getMatch() {
        return this.match;
    }

    public String getExpression() {
        return this.expression;
    }

    protected Object calculate() {
        StringBuilder sb = new StringBuilder();
        try {
            StringTokenizer tokenizer = new StringTokenizer(this.expression, "$", true);
            if (this.expression.isEmpty() || tokenizer.countTokens() == 0) {
                throw new IllegalArgumentException("Expression must not be empty.");
            }
            boolean inExpression = false;
            boolean foundToken = false;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("$")) {
                    if (inExpression && !foundToken) {
                        throw new IllegalArgumentException("Empty reference ($$) in message is not allowed.");
                    }
                    inExpression = !inExpression;
                    continue;
                }
                if (inExpression) {
                    IObservableValue value = IncQueryObservables.getObservableValue(this.match, token);
                    sb.append(value.getValue());
                    foundToken = true;
                    continue;
                }
                sb.append(token);
            }
            if (inExpression) {
                throw new IllegalArgumentException("Inconsistent model references - a $ character is missing.");
            }
        }
        catch (IllegalArgumentException e) {
            return "ERROR: " + e.getMessage();
        }
        return sb.toString();
    }
}

