/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific;

import com.google.common.base.Preconditions;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.Context;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.api.event.ActivationState;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;
import org.eclipse.incquery.runtime.evm.specific.job.EnableJob;
import org.eclipse.incquery.runtime.evm.specific.job.ErrorLoggingJob;
import org.eclipse.incquery.runtime.evm.specific.job.EventAtomEditingDomainProvider;
import org.eclipse.incquery.runtime.evm.specific.job.RecordingJob;
import org.eclipse.incquery.runtime.evm.specific.job.StatelessJob;

public final class TransactionalJobs {
    private TransactionalJobs() {
    }

    public static <Match extends IPatternMatch> Job<Match> newStatelessJob(IncQueryActivationStateEnum incQueryActivationStateEnum, IMatchProcessor<Match> processor) {
        return new StatelessJob(incQueryActivationStateEnum, processor);
    }

    public static <Match extends IPatternMatch> EventAtomEditingDomainProvider<Match> createMatchBasedEditingDomainProvider() {
        return new EventAtomEditingDomainProvider<Match>(){

            @Override
            public EditingDomain findEditingDomain(Activation<? extends Match> activation, Context context) {
                IPatternMatch match = (IPatternMatch)activation.getAtom();
                int arity = match.parameterNames().size();
                if (arity > 0) {
                    int i = 0;
                    while (i < arity) {
                        if (match.get(i) instanceof EObject) {
                            EObject eo = (EObject)match.get(i);
                            return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eo);
                        }
                        ++i;
                    }
                }
                return null;
            }
        };
    }

    public static <EventAtom> Job<EventAtom> newRecordingJob(Job<EventAtom> job) {
        return new RecordingJob<EventAtom>(job);
    }

    public static <EventAtom> Job<EventAtom> newRecordingJob(Job<EventAtom> job, EventAtomEditingDomainProvider<EventAtom> provider) {
        return new RecordingJob<EventAtom>(job, provider);
    }

    public static <EventAtom extends IPatternMatch> Job<EventAtom> newRecordingJobForMatchActivation(Job<EventAtom> job) {
        EventAtomEditingDomainProvider provider = TransactionalJobs.createMatchBasedEditingDomainProvider();
        return new RecordingJob<EventAtom>(job, provider);
    }

    public static final <EventAtom> Job<EventAtom> newNopJob(ActivationState activationState) {
        return new Job<EventAtom>(activationState){

            protected void execute(Activation<? extends EventAtom> activation, Context context) {
            }

            protected void handleError(Activation<? extends EventAtom> activation, Exception exception, Context context) {
                Preconditions.checkState((boolean)false, (Object)"NopJob should never cause errors!");
            }
        };
    }

    public static <EventAtom> Job<EventAtom> newEnableJob(Job<EventAtom> job) {
        return new EnableJob(job);
    }

    public static <EventAtom> Job<EventAtom> newErrorLoggingJob(Job<EventAtom> job) {
        return new ErrorLoggingJob(job);
    }
}

