/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.planner;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.incquery.runtime.localsearch.planner.ISearchPlanCodeGenerator;
import org.eclipse.incquery.runtime.localsearch.planner.LocalSearchPlannerStrategy;
import org.eclipse.incquery.runtime.localsearch.planner.POperationCompiler;
import org.eclipse.incquery.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.incquery.runtime.matchers.planning.IQueryPlannerStrategy;
import org.eclipse.incquery.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PBodyNormalizer;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PQueryFlattener;

public class LocalSearchPlanner {
    private PDisjunction flatDisjunction;
    private PDisjunction normalizedDisjunction;
    private List<SubPlan> plansForBodies;
    private PQueryFlattener flattener;
    private IQueryPlannerStrategy plannerStrategy;
    private PBodyNormalizer normalizer;
    private POperationCompiler operationCompiler;
    private ISearchPlanCodeGenerator codeGenerator;
    private Logger logger;
    private IQueryMetaContext context;

    public PDisjunction getFlatDisjunction() {
        return this.flatDisjunction;
    }

    public PDisjunction getNormalizedDisjunction() {
        return this.normalizedDisjunction;
    }

    public List<SubPlan> getPlansForBodies() {
        return this.plansForBodies;
    }

    public void initializePlanner(PQueryFlattener pQueryFlattener, Logger logger, IQueryMetaContext context, PBodyNormalizer pBodyNormalizer, IQueryPlannerStrategy localSearchPlannerStrategy, POperationCompiler pOperationCompiler) {
        this.initializePlanner(pQueryFlattener, logger, context, pBodyNormalizer, localSearchPlannerStrategy, pOperationCompiler, null);
    }

    public void initializePlanner(PQueryFlattener pQueryFlattener, Logger logger, IQueryMetaContext context, PBodyNormalizer pBodyNormalizer, IQueryPlannerStrategy localSearchPlannerStrategy, POperationCompiler pOperationCompiler, ISearchPlanCodeGenerator codeGenerator) {
        this.flattener = pQueryFlattener;
        this.logger = logger;
        this.context = context;
        this.normalizer = pBodyNormalizer;
        this.plannerStrategy = localSearchPlannerStrategy;
        this.operationCompiler = pOperationCompiler;
        this.codeGenerator = codeGenerator;
    }

    public Map<List<ISearchOperation>, Map<PVariable, Integer>> plan(PQuery querySpec, Set<Integer> boundVarIndices) throws QueryProcessingException {
        this.flatDisjunction = this.flattener.rewrite(querySpec.getDisjunctBodies());
        Set flatBodies = this.flatDisjunction.getBodies();
        this.prepareFlatBodesForNormalize(flatBodies);
        this.normalizedDisjunction = this.normalizer.rewrite(this.flatDisjunction);
        Set normalizedBodies = this.normalizedDisjunction.getBodies();
        this.plansForBodies = Lists.newArrayList();
        for (PBody normalizedBody : normalizedBodies) {
            this.preparePatternAdornmentForPlanner(boundVarIndices, normalizedBody);
            SubPlan plan = this.plannerStrategy.plan(normalizedBody, this.logger, this.context);
            this.plansForBodies.add(plan);
        }
        HashMap compiledSubPlans = Maps.newHashMap();
        for (SubPlan subPlan : this.plansForBodies) {
            List<ISearchOperation> compiledOperations = this.operationCompiler.compile(subPlan, boundVarIndices);
            compiledSubPlans.put(compiledOperations, this.operationCompiler.getVariableMappings());
        }
        return compiledSubPlans;
    }

    private void prepareFlatBodesForNormalize(Set<PBody> flatBodies) {
        for (PBody pBody : flatBodies) {
            pBody.setStatus(PQuery.PQueryStatus.UNINITIALIZED);
        }
    }

    private void preparePatternAdornmentForPlanner(Set<Integer> boundVarIndices, PBody normalizedBody) {
        HashSet boundVariables = Sets.newHashSet();
        for (Integer i : boundVarIndices) {
            boundVariables.add((PVariable)normalizedBody.getSymbolicParameterVariables().get(i));
        }
        ((LocalSearchPlannerStrategy)this.plannerStrategy).setBoundVariables(boundVariables);
    }
}

