/**
 */
package org.eclipse.incquery.runtime.rete.recipes;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Input Recipe</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Represents input nodes for the Rete network, i.e. nodes
 * that generate input tuples for processing.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.incquery.runtime.rete.recipes.InputRecipe#getInputKey <em>Input Key</em>}</li>
 *   <li>{@link org.eclipse.incquery.runtime.rete.recipes.InputRecipe#getKeyID <em>Key ID</em>}</li>
 *   <li>{@link org.eclipse.incquery.runtime.rete.recipes.InputRecipe#getKeyArity <em>Key Arity</em>}</li>
 * </ul>
 *
 * @see org.eclipse.incquery.runtime.rete.recipes.RecipesPackage#getInputRecipe()
 * @model
 * @generated
 */
public interface InputRecipe extends ReteNodeRecipe {
	/**
	 * Returns the value of the '<em><b>Input Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Input Key</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Input Key</em>' attribute.
	 * @see #setInputKey(Object)
	 * @see org.eclipse.incquery.runtime.rete.recipes.RecipesPackage#getInputRecipe_InputKey()
	 * @model transient="true"
	 * @generated
	 */
	Object getInputKey();

	/**
	 * Sets the value of the '{@link org.eclipse.incquery.runtime.rete.recipes.InputRecipe#getInputKey <em>Input Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Input Key</em>' attribute.
	 * @see #getInputKey()
	 * @generated
	 */
	void setInputKey(Object value);

	/**
	 * Returns the value of the '<em><b>Key ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Temporary construct for identifying types over the wire.
	 * TODO improve type references
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Key ID</em>' attribute.
	 * @see #setKeyID(String)
	 * @see org.eclipse.incquery.runtime.rete.recipes.RecipesPackage#getInputRecipe_KeyID()
	 * @model unique="false"
	 * @generated
	 */
	String getKeyID();

	/**
	 * Sets the value of the '{@link org.eclipse.incquery.runtime.rete.recipes.InputRecipe#getKeyID <em>Key ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Key ID</em>' attribute.
	 * @see #getKeyID()
	 * @generated
	 */
	void setKeyID(String value);

	/**
	 * Returns the value of the '<em><b>Key Arity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Key Arity</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Key Arity</em>' attribute.
	 * @see #setKeyArity(int)
	 * @see org.eclipse.incquery.runtime.rete.recipes.RecipesPackage#getInputRecipe_KeyArity()
	 * @model
	 * @generated
	 */
	int getKeyArity();

	/**
	 * Sets the value of the '{@link org.eclipse.incquery.runtime.rete.recipes.InputRecipe#getKeyArity <em>Key Arity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Key Arity</em>' attribute.
	 * @see #getKeyArity()
	 * @generated
	 */
	void setKeyArity(int value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation" unique="false"
	 *        annotation="http://www.eclipse.org/emf/2002/GenModel body='return getKeyArity();'"
	 * @generated
	 */
	int getArity();

} // InputRecipe
