package org.eclipse.incquery.uml.derivedfeatures;

import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.uml.derivedfeatures.ClassifierParentsMatcher;
import org.eclipse.incquery.uml.derivedfeatures.OperationReturnResultMatcher;
import org.eclipse.incquery.uml.derivedfeatures.util.ClassifierParentsQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.OperationReturnResultQuerySpecification;

/**
 * A pattern group formed of all patterns defined in UsedOperations.eiq.
 * 
 * <p>Use the static instance as any {@link org.eclipse.incquery.runtime.api.IPatternGroup}, to conveniently prepare
 * an EMF-IncQuery engine for matching all patterns originally defined in file UsedOperations.eiq,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.incquery.uml.derivedfeatures, the group contains the definition of the following patterns: <ul>
 * <li>classifierParents</li>
 * <li>operationReturnResult</li>
 * </ul>
 * 
 * @see IPatternGroup
 * 
 */
@SuppressWarnings("all")
public final class UsedOperations extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws IncQueryException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static UsedOperations instance() throws IncQueryException {
    if (INSTANCE == null) {
    	INSTANCE = new UsedOperations();
    }
    return INSTANCE;
  }
  
  private static UsedOperations INSTANCE;
  
  private UsedOperations() throws IncQueryException {
    querySpecifications.add(ClassifierParentsQuerySpecification.instance());
    querySpecifications.add(OperationReturnResultQuerySpecification.instance());
  }
  
  public ClassifierParentsQuerySpecification getClassifierParents() throws IncQueryException {
    return ClassifierParentsQuerySpecification.instance();
  }
  
  public ClassifierParentsMatcher getClassifierParents(final IncQueryEngine engine) throws IncQueryException {
    return ClassifierParentsMatcher.on(engine);
  }
  
  public OperationReturnResultQuerySpecification getOperationReturnResult() throws IncQueryException {
    return OperationReturnResultQuerySpecification.instance();
  }
  
  public OperationReturnResultMatcher getOperationReturnResult(final IncQueryEngine engine) throws IncQueryException {
    return OperationReturnResultMatcher.on(engine);
  }
}
