package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.incquery.runtime.matchers.psystem.IValueProvider;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.NamedElementQualifiedNameMatch;
import org.eclipse.incquery.uml.derivedfeatures.NamedElementQualifiedNameMatcher;
import org.eclipse.incquery.uml.derivedfeatures.util.NamedElementNamespaceQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate NamedElementQualifiedNameMatcher in a type-safe way.
 * 
 * @see NamedElementQualifiedNameMatcher
 * @see NamedElementQualifiedNameMatch
 * 
 */
@SuppressWarnings("all")
public final class NamedElementQualifiedNameQuerySpecification extends BaseGeneratedEMFQuerySpecification<NamedElementQualifiedNameMatcher> {
  private NamedElementQualifiedNameQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static NamedElementQualifiedNameQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected NamedElementQualifiedNameMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return NamedElementQualifiedNameMatcher.on(engine);
  }
  
  @Override
  public NamedElementQualifiedNameMatch newEmptyMatch() {
    return NamedElementQualifiedNameMatch.newEmptyMatch();
  }
  
  @Override
  public NamedElementQualifiedNameMatch newMatch(final Object... parameters) {
    return NamedElementQualifiedNameMatch.newMatch((org.eclipse.uml2.uml.NamedElement) parameters[0], (java.lang.Object) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static NamedElementQualifiedNameQuerySpecification INSTANCE = make();
    
    public static NamedElementQualifiedNameQuerySpecification make() {
      return new NamedElementQualifiedNameQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static NamedElementQualifiedNameQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.namedElementQualifiedName";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("namedElement","qualifiedName");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("namedElement", "org.eclipse.uml2.uml.NamedElement"),new PParameter("qualifiedName", "java.lang.Object"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_namedElement = body.getOrCreateVariableByName("namedElement");
      	PVariable var_qualifiedName = body.getOrCreateVariableByName("qualifiedName");
      	PVariable var___0_ = body.getOrCreateVariableByName("_<0>");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_namedElement, "namedElement"),
      				
      		new ExportedParameter(body, var_qualifiedName, "qualifiedName")
      	));
      	new TypeConstraint(body, new FlatTuple(var_namedElement), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
      	new NegativePatternCall(body, new FlatTuple(var_namedElement, var___0_), NamedElementNamespaceQuerySpecification.instance().getInternalQueryRepresentation());
      	new TypeConstraint(body, new FlatTuple(var_namedElement), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
      	new TypeConstraint(body, new FlatTuple(var_namedElement, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement", "name")));
      	new Equality(body, var__virtual_0_, var_qualifiedName);
      	bodies.add(body);
      }
      {
      	PBody body = new PBody(this);
      	PVariable var_namedElement = body.getOrCreateVariableByName("namedElement");
      	PVariable var_qualifiedName = body.getOrCreateVariableByName("qualifiedName");
      	PVariable var_namespace = body.getOrCreateVariableByName("namespace");
      	PVariable var_name = body.getOrCreateVariableByName("name");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var_namespaceQualifiedName = body.getOrCreateVariableByName("namespaceQualifiedName");
      	PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_namedElement, "namedElement"),
      				
      		new ExportedParameter(body, var_qualifiedName, "qualifiedName")
      	));
      	new TypeConstraint(body, new FlatTuple(var_namedElement), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
      	new PositivePatternCall(body, new FlatTuple(var_namedElement, var_namespace), NamedElementNamespaceQuerySpecification.instance().getInternalQueryRepresentation());
      	new TypeConstraint(body, new FlatTuple(var_namedElement), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
      	new TypeConstraint(body, new FlatTuple(var_namedElement, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement", "name")));
      	new Equality(body, var__virtual_0_, var_name);
      	new PositivePatternCall(body, new FlatTuple(var_namespace, var_namespaceQualifiedName), this);
      new ExpressionEvaluation(body, new IExpressionEvaluator() {
      	
      	@Override
      	public String getShortDescription() {
      		return "Expression evaluation from pattern namedElementQualifiedName";
      	}
      
      	@Override
      	public Iterable<String> getInputParameterNames() {
      		return Arrays.asList("name", "namespaceQualifiedName");
      	}
      
      	@Override
      	public Object evaluateExpression(IValueProvider provider) throws Exception {
      			java.lang.String name = (java.lang.String) provider.getValue("name");
      			java.lang.Object namespaceQualifiedName = (java.lang.Object) provider.getValue("namespaceQualifiedName");
      			return evaluateExpression_2_1(name, namespaceQualifiedName);
      		}
      
      },  var__virtual_1_ ); 
      	new Equality(body, var_qualifiedName, var__virtual_1_);
      	bodies.add(body);
      }
      	{
      	PAnnotation annotation = new PAnnotation("Surrogate");
      	annotation.addAttribute("feature", "qualifiedName");
      	addAnnotation(annotation);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
  
  private static String evaluateExpression_2_1(final String name, final Object namespaceQualifiedName) {
    String _plus = (namespaceQualifiedName + "::");
    String _plus_1 = (_plus + name);
    return _plus_1;
  }
}
