package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.incquery.runtime.matchers.psystem.IValueProvider;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.StateIsOrthogonalMatch;
import org.eclipse.incquery.uml.derivedfeatures.StateIsOrthogonalMatcher;
import org.eclipse.incquery.uml.derivedfeatures.util.StateIsComposite_0QuerySpecification;

/**
 * A pattern-specific query specification that can instantiate StateIsOrthogonalMatcher in a type-safe way.
 * 
 * @see StateIsOrthogonalMatcher
 * @see StateIsOrthogonalMatch
 * 
 */
@SuppressWarnings("all")
public final class StateIsOrthogonalQuerySpecification extends BaseGeneratedEMFQuerySpecification<StateIsOrthogonalMatcher> {
  private StateIsOrthogonalQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static StateIsOrthogonalQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected StateIsOrthogonalMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return StateIsOrthogonalMatcher.on(engine);
  }
  
  @Override
  public StateIsOrthogonalMatch newEmptyMatch() {
    return StateIsOrthogonalMatch.newEmptyMatch();
  }
  
  @Override
  public StateIsOrthogonalMatch newMatch(final Object... parameters) {
    return StateIsOrthogonalMatch.newMatch((org.eclipse.uml2.uml.State) parameters[0], (java.lang.Boolean) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static StateIsOrthogonalQuerySpecification INSTANCE = make();
    
    public static StateIsOrthogonalQuerySpecification make() {
      return new StateIsOrthogonalQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static StateIsOrthogonalQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.stateIsOrthogonal";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("source","target");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("source", "org.eclipse.uml2.uml.State"),new PParameter("target", "java.lang.Boolean"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_source = body.getOrCreateVariableByName("source");
      	PVariable var_target = body.getOrCreateVariableByName("target");
      	PVariable var_regionCount = body.getOrCreateVariableByName("regionCount");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var__region = body.getOrCreateVariableByName("_region");
      	PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_source, "source"),
      				
      		new ExportedParameter(body, var_target, "target")
      	));
      	new TypeConstraint(body, new FlatTuple(var_source), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "State")));
      	new PatternMatchCounter(body, new FlatTuple(var_source, var__region), StateIsComposite_0QuerySpecification.instance().getInternalQueryRepresentation(), var__virtual_0_);
      	new Equality(body, var_regionCount, var__virtual_0_);
      new ExpressionEvaluation(body, new IExpressionEvaluator() {
      	
      	@Override
      	public String getShortDescription() {
      		return "Expression evaluation from pattern stateIsOrthogonal";
      	}
      
      	@Override
      	public Iterable<String> getInputParameterNames() {
      		return Arrays.asList("regionCount");
      	}
      
      	@Override
      	public Object evaluateExpression(IValueProvider provider) throws Exception {
      			java.lang.Integer regionCount = (java.lang.Integer) provider.getValue("regionCount");
      			return evaluateExpression_1_1(regionCount);
      		}
      
      },  var__virtual_1_ ); 
      	new Equality(body, var_target, var__virtual_1_);
      	bodies.add(body);
      }
      	{
      	PAnnotation annotation = new PAnnotation("Surrogate");
      	annotation.addAttribute("feature", "isOrthogonal");
      	addAnnotation(annotation);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
  
  private static boolean evaluateExpression_1_1(final Integer regionCount) {
    return ((regionCount).intValue() > 1);
  }
}
