/**
 */
package org.eclipse.incquery.viewers.runtime.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.incquery.viewers.runtime.model.FormatSpecification;
import org.eclipse.incquery.viewers.runtime.model.HierarchyPolicy;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.NotationPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Item</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.incquery.viewers.runtime.model.impl.ItemImpl#getLabel <em>Label</em>}</li>
 *   <li>{@link org.eclipse.incquery.viewers.runtime.model.impl.ItemImpl#getFormat <em>Format</em>}</li>
 *   <li>{@link org.eclipse.incquery.viewers.runtime.model.impl.ItemImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.incquery.viewers.runtime.model.impl.ItemImpl#getParent <em>Parent</em>}</li>
 *   <li>{@link org.eclipse.incquery.viewers.runtime.model.impl.ItemImpl#getChildren <em>Children</em>}</li>
 *   <li>{@link org.eclipse.incquery.viewers.runtime.model.impl.ItemImpl#getPolicy <em>Policy</em>}</li>
 *   <li>{@link org.eclipse.incquery.viewers.runtime.model.impl.ItemImpl#getParamObject <em>Param Object</em>}</li>
 *   <li>{@link org.eclipse.incquery.viewers.runtime.model.impl.ItemImpl#getParamEObject <em>Param EObject</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ItemImpl extends MinimalEObjectImpl.Container implements Item {
	/**
	 * The default value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected static final String LABEL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected String label = LABEL_EDEFAULT;

	/**
	 * The cached value of the '{@link #getFormat() <em>Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFormat()
	 * @generated
	 * @ordered
	 */
	protected FormatSpecification format;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getParent() <em>Parent</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParent()
	 * @generated
	 * @ordered
	 */
	protected Item parent;

	/**
	 * The cached value of the '{@link #getChildren() <em>Children</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChildren()
	 * @generated
	 * @ordered
	 */
	protected EList<Item> children;

	/**
	 * The default value of the '{@link #getPolicy() <em>Policy</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPolicy()
	 * @generated
	 * @ordered
	 */
	protected static final HierarchyPolicy POLICY_EDEFAULT = HierarchyPolicy.PORT;

	/**
	 * The cached value of the '{@link #getPolicy() <em>Policy</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPolicy()
	 * @generated
	 * @ordered
	 */
	protected HierarchyPolicy policy = POLICY_EDEFAULT;

	/**
	 * The default value of the '{@link #getParamObject() <em>Param Object</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParamObject()
	 * @generated
	 * @ordered
	 */
	protected static final Object PARAM_OBJECT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getParamObject() <em>Param Object</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParamObject()
	 * @generated
	 * @ordered
	 */
	protected Object paramObject = PARAM_OBJECT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getParamEObject() <em>Param EObject</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParamEObject()
	 * @generated
	 * @ordered
	 */
	protected EObject paramEObject;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ItemImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NotationPackage.Literals.ITEM;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLabel(String newLabel) {
		String oldLabel = label;
		label = newLabel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotationPackage.ITEM__LABEL, oldLabel, label));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FormatSpecification getFormat() {
		return format;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFormat(FormatSpecification newFormat, NotificationChain msgs) {
		FormatSpecification oldFormat = format;
		format = newFormat;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, NotationPackage.ITEM__FORMAT, oldFormat, newFormat);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFormat(FormatSpecification newFormat) {
		if (newFormat != format) {
			NotificationChain msgs = null;
			if (format != null)
				msgs = ((InternalEObject)format).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - NotationPackage.ITEM__FORMAT, null, msgs);
			if (newFormat != null)
				msgs = ((InternalEObject)newFormat).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - NotationPackage.ITEM__FORMAT, null, msgs);
			msgs = basicSetFormat(newFormat, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotationPackage.ITEM__FORMAT, newFormat, newFormat));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotationPackage.ITEM__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Item getParent() {
		if (parent != null && parent.eIsProxy()) {
			InternalEObject oldParent = (InternalEObject)parent;
			parent = (Item)eResolveProxy(oldParent);
			if (parent != oldParent) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, NotationPackage.ITEM__PARENT, oldParent, parent));
			}
		}
		return parent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Item basicGetParent() {
		return parent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParent(Item newParent, NotificationChain msgs) {
		Item oldParent = parent;
		parent = newParent;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, NotationPackage.ITEM__PARENT, oldParent, newParent);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(Item newParent) {
		if (newParent != parent) {
			NotificationChain msgs = null;
			if (parent != null)
				msgs = ((InternalEObject)parent).eInverseRemove(this, NotationPackage.ITEM__CHILDREN, Item.class, msgs);
			if (newParent != null)
				msgs = ((InternalEObject)newParent).eInverseAdd(this, NotationPackage.ITEM__CHILDREN, Item.class, msgs);
			msgs = basicSetParent(newParent, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotationPackage.ITEM__PARENT, newParent, newParent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Item> getChildren() {
		if (children == null) {
			children = new EObjectWithInverseResolvingEList<Item>(Item.class, this, NotationPackage.ITEM__CHILDREN, NotationPackage.ITEM__PARENT);
		}
		return children;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HierarchyPolicy getPolicy() {
		return policy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPolicy(HierarchyPolicy newPolicy) {
		HierarchyPolicy oldPolicy = policy;
		policy = newPolicy == null ? POLICY_EDEFAULT : newPolicy;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotationPackage.ITEM__POLICY, oldPolicy, policy));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getParamObject() {
		return paramObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParamObject(Object newParamObject) {
		Object oldParamObject = paramObject;
		paramObject = newParamObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotationPackage.ITEM__PARAM_OBJECT, oldParamObject, paramObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject getParamEObject() {
		if (paramEObject != null && paramEObject.eIsProxy()) {
			InternalEObject oldParamEObject = (InternalEObject)paramEObject;
			paramEObject = eResolveProxy(oldParamEObject);
			if (paramEObject != oldParamEObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, NotationPackage.ITEM__PARAM_EOBJECT, oldParamEObject, paramEObject));
			}
		}
		return paramEObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject basicGetParamEObject() {
		return paramEObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParamEObject(EObject newParamEObject) {
		EObject oldParamEObject = paramEObject;
		paramEObject = newParamEObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotationPackage.ITEM__PARAM_EOBJECT, oldParamEObject, paramEObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NotationPackage.ITEM__PARENT:
				if (parent != null)
					msgs = ((InternalEObject)parent).eInverseRemove(this, NotationPackage.ITEM__CHILDREN, Item.class, msgs);
				return basicSetParent((Item)otherEnd, msgs);
			case NotationPackage.ITEM__CHILDREN:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getChildren()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NotationPackage.ITEM__FORMAT:
				return basicSetFormat(null, msgs);
			case NotationPackage.ITEM__PARENT:
				return basicSetParent(null, msgs);
			case NotationPackage.ITEM__CHILDREN:
				return ((InternalEList<?>)getChildren()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NotationPackage.ITEM__LABEL:
				return getLabel();
			case NotationPackage.ITEM__FORMAT:
				return getFormat();
			case NotationPackage.ITEM__ID:
				return getId();
			case NotationPackage.ITEM__PARENT:
				if (resolve) return getParent();
				return basicGetParent();
			case NotationPackage.ITEM__CHILDREN:
				return getChildren();
			case NotationPackage.ITEM__POLICY:
				return getPolicy();
			case NotationPackage.ITEM__PARAM_OBJECT:
				return getParamObject();
			case NotationPackage.ITEM__PARAM_EOBJECT:
				if (resolve) return getParamEObject();
				return basicGetParamEObject();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NotationPackage.ITEM__LABEL:
				setLabel((String)newValue);
				return;
			case NotationPackage.ITEM__FORMAT:
				setFormat((FormatSpecification)newValue);
				return;
			case NotationPackage.ITEM__ID:
				setId((String)newValue);
				return;
			case NotationPackage.ITEM__PARENT:
				setParent((Item)newValue);
				return;
			case NotationPackage.ITEM__CHILDREN:
				getChildren().clear();
				getChildren().addAll((Collection<? extends Item>)newValue);
				return;
			case NotationPackage.ITEM__POLICY:
				setPolicy((HierarchyPolicy)newValue);
				return;
			case NotationPackage.ITEM__PARAM_OBJECT:
				setParamObject(newValue);
				return;
			case NotationPackage.ITEM__PARAM_EOBJECT:
				setParamEObject((EObject)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NotationPackage.ITEM__LABEL:
				setLabel(LABEL_EDEFAULT);
				return;
			case NotationPackage.ITEM__FORMAT:
				setFormat((FormatSpecification)null);
				return;
			case NotationPackage.ITEM__ID:
				setId(ID_EDEFAULT);
				return;
			case NotationPackage.ITEM__PARENT:
				setParent((Item)null);
				return;
			case NotationPackage.ITEM__CHILDREN:
				getChildren().clear();
				return;
			case NotationPackage.ITEM__POLICY:
				setPolicy(POLICY_EDEFAULT);
				return;
			case NotationPackage.ITEM__PARAM_OBJECT:
				setParamObject(PARAM_OBJECT_EDEFAULT);
				return;
			case NotationPackage.ITEM__PARAM_EOBJECT:
				setParamEObject((EObject)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NotationPackage.ITEM__LABEL:
				return LABEL_EDEFAULT == null ? label != null : !LABEL_EDEFAULT.equals(label);
			case NotationPackage.ITEM__FORMAT:
				return format != null;
			case NotationPackage.ITEM__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case NotationPackage.ITEM__PARENT:
				return parent != null;
			case NotationPackage.ITEM__CHILDREN:
				return children != null && !children.isEmpty();
			case NotationPackage.ITEM__POLICY:
				return policy != POLICY_EDEFAULT;
			case NotationPackage.ITEM__PARAM_OBJECT:
				return PARAM_OBJECT_EDEFAULT == null ? paramObject != null : !PARAM_OBJECT_EDEFAULT.equals(paramObject);
			case NotationPackage.ITEM__PARAM_EOBJECT:
				return paramEObject != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (label: ");
		result.append(label);
		result.append(", id: ");
		result.append(id);
		result.append(", policy: ");
		result.append(policy);
		result.append(", paramObject: ");
		result.append(paramObject);
		result.append(')');
		return result.toString();
	}

} //ItemImpl
