/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.operations.check;

import java.util.Map;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.incquery.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.incquery.runtime.localsearch.operations.check.CheckOperation;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public class CountCheck
extends CheckOperation {
    private PQuery calledQuery;
    private LocalSearchMatcher matcher;
    Map<Integer, Integer> frameMapping;
    private int position;

    public CountCheck(PQuery calledQuery, Map<Integer, Integer> frameMapping, int position) {
        this.calledQuery = calledQuery;
        this.frameMapping = frameMapping;
        this.position = position;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        super.onInitialize(frame, context);
        this.matcher = context.getMatcher(this.calledQuery);
    }

    @Override
    protected boolean check(MatchingFrame frame) throws LocalSearchException {
        MatchingFrame mappedFrame = this.matcher.editableMatchingFrame();
        for (Map.Entry<Integer, Integer> entry : this.frameMapping.entrySet()) {
            mappedFrame.setValue(entry.getValue(), frame.getValue(entry.getKey()));
        }
        int count = this.matcher.countMatches(mappedFrame);
        return (Integer)frame.getValue(this.position) == count;
    }
}

