/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.operations.check;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.incquery.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.incquery.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.incquery.runtime.localsearch.operations.IMatcherBasedOperation;
import org.eclipse.incquery.runtime.localsearch.operations.check.CheckOperation;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public class BinaryTransitiveClosureCheck
extends CheckOperation
implements IMatcherBasedOperation {
    private PQuery calledQuery;
    private LocalSearchMatcher matcher;
    private int sourcePosition;
    private int targetPosition;

    @Override
    public LocalSearchMatcher getAndPrepareCalledMatcher(MatchingFrame frame, ISearchContext context) {
        ImmutableSet adornment = ImmutableSet.of((Object)0);
        this.matcher = context.getMatcher(new MatcherReference(this.calledQuery, (Set<Integer>)adornment));
        return this.matcher;
    }

    @Override
    public LocalSearchMatcher getCalledMatcher() {
        return this.matcher;
    }

    public BinaryTransitiveClosureCheck(PQuery calledQuery, int sourcePosition, int targetPosition) {
        this.calledQuery = calledQuery;
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
    }

    public PQuery getCalledQuery() {
        return this.calledQuery;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        super.onInitialize(frame, context);
        this.getAndPrepareCalledMatcher(frame, context);
    }

    @Override
    protected boolean check(MatchingFrame frame) throws LocalSearchException {
        Object targetValue = frame.get(this.targetPosition);
        LinkedHashSet sourcesToEvaluate = Sets.newLinkedHashSet();
        sourcesToEvaluate.add(frame.get(this.sourcePosition));
        HashSet sourceEvaluated = Sets.newHashSet();
        do {
            Object currentValue = sourcesToEvaluate.iterator().next();
            sourcesToEvaluate.remove(currentValue);
            sourceEvaluated.add(currentValue);
            MatchingFrame mappedFrame = this.matcher.editableMatchingFrame();
            mappedFrame.setValue(0, currentValue);
            for (MatchingFrame match : this.matcher.getAllMatches(mappedFrame)) {
                Object foundTarget = match.get(1);
                if (targetValue.equals(foundTarget)) {
                    return true;
                }
                if (sourceEvaluated.contains(foundTarget)) continue;
                sourcesToEvaluate.add(foundTarget);
            }
        } while (!sourcesToEvaluate.isEmpty());
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Binary transitive colsure, pattern: ").append(this.calledQuery.getFullyQualifiedName().substring(this.calledQuery.getFullyQualifiedName().lastIndexOf(46) + 1));
        return builder.toString();
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.sourcePosition, (Object)this.targetPosition, (Object[])new Integer[0]);
    }
}

