/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.operations.check;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.incquery.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.incquery.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.incquery.runtime.localsearch.operations.IMatcherBasedOperation;
import org.eclipse.incquery.runtime.localsearch.operations.check.CheckOperation;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public class CountCheck
extends CheckOperation
implements IMatcherBasedOperation {
    private PQuery calledQuery;
    private LocalSearchMatcher matcher;
    Map<Integer, Integer> frameMapping;
    private int position;

    @Override
    public LocalSearchMatcher getAndPrepareCalledMatcher(MatchingFrame frame, ISearchContext context) {
        HashSet adornment = Sets.newHashSet();
        for (Map.Entry<Integer, Integer> mapping : this.frameMapping.entrySet()) {
            Integer source = mapping.getKey();
            if (frame.get(source) == null) continue;
            adornment.add(mapping.getValue());
        }
        this.matcher = context.getMatcher(new MatcherReference(this.calledQuery, adornment));
        return this.matcher;
    }

    @Override
    public LocalSearchMatcher getCalledMatcher() {
        return this.matcher;
    }

    public CountCheck(PQuery calledQuery, Map<Integer, Integer> frameMapping, int position) {
        this.calledQuery = calledQuery;
        this.frameMapping = frameMapping;
        this.position = position;
    }

    public PQuery getCalledQuery() {
        return this.calledQuery;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        super.onInitialize(frame, context);
        this.getAndPrepareCalledMatcher(frame, context);
    }

    @Override
    protected boolean check(MatchingFrame frame) throws LocalSearchException {
        MatchingFrame mappedFrame = this.matcher.editableMatchingFrame();
        for (Map.Entry<Integer, Integer> entry : this.frameMapping.entrySet()) {
            mappedFrame.setValue(entry.getValue(), frame.getValue(entry.getKey()));
        }
        int count = this.matcher.countMatches(mappedFrame);
        return (Integer)frame.getValue(this.position) == count;
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.position, (Object[])new Integer[0]);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Count check for pattern ").append(this.calledQuery.getFullyQualifiedName().substring(this.calledQuery.getFullyQualifiedName().lastIndexOf(46) + 1));
        return super.toString();
    }
}

