/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.planner.rewriters;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.matchers.context.IInputKey;
import org.eclipse.incquery.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.incquery.runtime.matchers.planning.helpers.TypeHelper;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PBodyCopier;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.RewriterException;

public class PBodyUnaryTypeNormalizer
extends PDisjunctionRewriter {
    private IQueryMetaContext context;

    public PBodyUnaryTypeNormalizer(IQueryMetaContext context) {
        this.context = context;
    }

    public PDisjunction rewrite(PDisjunction disjunction) throws RewriterException {
        HashSet normalizedBodies = Sets.newHashSet();
        for (PBody body : disjunction.getBodies()) {
            PBodyCopier copier = new PBodyCopier(body);
            PBody modifiedBody = copier.getCopiedBody();
            this.normalizeBody(modifiedBody);
            normalizedBodies.add(modifiedBody);
            modifiedBody.setStatus(PQuery.PQueryStatus.OK);
        }
        return new PDisjunction((Set)normalizedBodies);
    }

    private void normalizeBody(PBody body) {
        HashSet subsumedByRetainedConstraints = new HashSet();
        LinkedList<TypeConstraint> allUnaryTypeConstraints = new LinkedList<TypeConstraint>();
        for (PConstraint pConstraint : body.getConstraints()) {
            TypeConstraint typeConstraint;
            IInputKey inputKey;
            if (!(pConstraint instanceof TypeConstraint) || !((inputKey = (IInputKey)(typeConstraint = (TypeConstraint)pConstraint).getSupplierKey()) instanceof EClassTransitiveInstancesKey)) continue;
            allUnaryTypeConstraints.add((TypeConstraint)pConstraint);
        }
        Collections.sort(allUnaryTypeConstraints, PConstraint.CompareByMonotonousID.INSTANCE);
        LinkedList<TypeConstraint> potentialConstraints = allUnaryTypeConstraints;
        while (!potentialConstraints.isEmpty()) {
            TypeConstraint candidate = (TypeConstraint)potentialConstraints.poll();
            boolean isSubsumed = subsumedByRetainedConstraints.contains(candidate.getEquivalentJudgement());
            if (!isSubsumed) {
                for (TypeConstraint subsuming : potentialConstraints) {
                    Set directJudgements = subsuming.getImpliedJudgements(this.context);
                    Set typeClosure = TypeHelper.typeClosure((Set)directJudgements, (IQueryMetaContext)this.context);
                    if (!typeClosure.contains(candidate.getEquivalentJudgement())) continue;
                    isSubsumed = true;
                    break;
                }
            }
            if (isSubsumed) {
                candidate.delete();
                continue;
            }
            subsumedByRetainedConstraints.addAll(TypeHelper.typeClosure((Set)candidate.getImpliedJudgements(this.context), (IQueryMetaContext)this.context));
        }
    }

    public void setContext(IQueryMetaContext context) {
        this.context = context;
    }
}

