package org.eclipse.incquery.viewers.runtime.model.patterns.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.patterns.ChildrenMatch;

/**
 * A match processor tailored for the org.eclipse.incquery.viewers.runtime.model.patterns.children pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class ChildrenProcessor implements IMatchProcessor<ChildrenMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pParent the value of pattern parameter parent in the currently processed match
   * @param pChild the value of pattern parameter child in the currently processed match
   * 
   */
  public abstract void process(final Item pParent, final Item pChild);
  
  @Override
  public void process(final ChildrenMatch match) {
    process(match.getParent(), match.getChild());
  }
}
