/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.MultiList;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchList;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchSet;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.Scheduler;
import org.eclipse.incquery.runtime.evm.api.resolver.ConflictResolver;
import org.eclipse.incquery.runtime.evm.specific.ExecutionSchemas;
import org.eclipse.incquery.runtime.evm.specific.Schedulers;
import org.eclipse.incquery.runtime.evm.specific.resolver.FixedPriorityConflictResolver;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.converters.ContainmentList;
import org.eclipse.incquery.viewers.runtime.model.converters.ContainmentSet;
import org.eclipse.incquery.viewers.runtime.model.converters.EdgeList;
import org.eclipse.incquery.viewers.runtime.model.converters.EdgeSet;
import org.eclipse.incquery.viewers.runtime.model.converters.FixedUnionSet;
import org.eclipse.incquery.viewers.runtime.model.converters.ItemConverter;
import org.eclipse.incquery.viewers.runtime.util.ViewersConflictResolver;

public class ViewerDataModel {
    private static final int NODE_PRIORITY = 1;
    private static final int CONTAINMENT_PRIORITY = 2;
    private static final int EDGE_PRIORITY = 3;
    private IncQueryEngine engine;
    private Logger logger;
    private ResourceSet model;
    private Set<Pattern> patterns;
    private RuleEngine ruleEngine;
    private FixedPriorityConflictResolver resolver;

    public ViewerDataModel(ResourceSet model, Collection<Pattern> patterns, IncQueryEngine engine) {
        this.model = model;
        this.patterns = Sets.newHashSet(patterns);
        this.engine = engine;
        this.logger = engine.getLogger();
        this.ruleEngine = ExecutionSchemas.createIncQueryExecutionSchema((IncQueryEngine)engine, (Scheduler.ISchedulerFactory)Schedulers.getIQEngineSchedulerFactory((IncQueryEngine)engine));
        this.resolver = new ViewersConflictResolver();
        this.ruleEngine.setConflictResolver((ConflictResolver)this.resolver);
    }

    public IncQueryEngine getEngine() {
        return this.engine;
    }

    public ResourceSet getModel() {
        return this.model;
    }

    public Collection<Pattern> getPatterns(String annotation) {
        return this.patterns;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public IObservableSet initializeObservableItemSet(Multimap<Object, Item> itemMap) {
        return this.initializeObservableItemSet(ViewerDataFilter.UNFILTERED, itemMap);
    }

    public IObservableList initializeObservableItemList(Multimap<Object, Item> itemMap) {
        return this.initializeObservableItemList(ViewerDataFilter.UNFILTERED, itemMap);
    }

    public IObservableSet initializeObservableItemSet(ViewerDataFilter filter, final Multimap<Object, Item> itemMap) {
        HashSet<WritableSet> nodeSetsObservable = new HashSet<WritableSet>();
        for (Pattern nodePattern : this.getPatterns("Item")) {
            DataBindingContext ctx = new DataBindingContext();
            ObservablePatternMatchSet<IPatternMatch> nodeSet = filter.getObservableSet(nodePattern, this.ruleEngine);
            this.resolver.setPriority(nodeSet.getSpecification(), 1);
            Annotation formatAnnotation = CorePatternLanguageHelper.getFirstAnnotationByName((Pattern)nodePattern, (String)"Format");
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)nodePattern, (String)"Item")) {
                WritableSet resultSet = new WritableSet();
                nodeSetsObservable.add(resultSet);
                ctx.bindSet((IObservableSet)resultSet, nodeSet, null, new UpdateSetStrategy().setConverter((IConverter)new ItemConverter(annotation, formatAnnotation)));
            }
        }
        FixedUnionSet Set2 = new FixedUnionSet(nodeSetsObservable.toArray(new IObservableSet[0]));
        Iterator iterator = Set2.iterator();
        while (iterator.hasNext()) {
            Object _item = iterator.next();
            Item item = (Item)_item;
            itemMap.put(item.getParamObject(), (Object)item);
        }
        Set2.addSetChangeListener(new ISetChangeListener(){

            public void handleSetChange(SetChangeEvent event) {
                Item item;
                for (Object element : event.diff.getAdditions()) {
                    if (!(element instanceof Item)) continue;
                    item = (Item)element;
                    itemMap.put(item.getParamObject(), (Object)item);
                }
                for (Object element : event.diff.getRemovals()) {
                    if (!(element instanceof Item)) continue;
                    item = (Item)element;
                    Object paramObject = item.getParamObject();
                    itemMap.remove(paramObject, element);
                }
            }
        });
        return Set2;
    }

    public IObservableList initializeObservableItemList(ViewerDataFilter filter, final Multimap<Object, Item> itemMap) {
        ArrayList<WritableList> nodeListsObservable = new ArrayList<WritableList>();
        for (Pattern nodePattern : this.getPatterns("Item")) {
            DataBindingContext ctx = new DataBindingContext();
            ObservablePatternMatchList<IPatternMatch> nodeList = filter.getObservableList(nodePattern, this.ruleEngine);
            this.resolver.setPriority(nodeList.getSpecification(), 1);
            Annotation formatAnnotation = CorePatternLanguageHelper.getFirstAnnotationByName((Pattern)nodePattern, (String)"Format");
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)nodePattern, (String)"Item")) {
                WritableList resultList = new WritableList();
                nodeListsObservable.add(resultList);
                ctx.bindList((IObservableList)resultList, nodeList, null, new UpdateListStrategy().setConverter((IConverter)new ItemConverter(annotation, formatAnnotation)));
            }
        }
        MultiList list = new MultiList((IObservableList[])nodeListsObservable.toArray(new ObservableList[nodeListsObservable.size()]));
        for (Object _item : list) {
            Item item = (Item)_item;
            itemMap.put(item.getParamObject(), (Object)item);
        }
        list.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                event.diff.accept(new ListDiffVisitor(){

                    public void handleRemove(int index, Object element) {
                        if (element instanceof Item) {
                            Item item = (Item)element;
                            Object paramObject = item.getParamObject();
                            itemMap.remove(paramObject, element);
                        }
                    }

                    public void handleAdd(int index, Object element) {
                        if (element instanceof Item) {
                            Item item = (Item)element;
                            itemMap.put(item.getParamObject(), (Object)item);
                        }
                    }
                });
            }
        });
        return list;
    }

    public IObservableSet initializeObservableEdgeSet(Multimap<Object, Item> itemMap) {
        return this.initializeObservableEdgeSet(ViewerDataFilter.UNFILTERED, itemMap);
    }

    public MultiList initializeObservableEdgeList(Multimap<Object, Item> itemMap) {
        return this.initializeObservableEdgeList(ViewerDataFilter.UNFILTERED, itemMap);
    }

    public IObservableSet initializeObservableEdgeSet(ViewerDataFilter filter, Multimap<Object, Item> itemMap) {
        HashSet<EdgeSet> edgeSetsObservable = new HashSet<EdgeSet>();
        for (Pattern edgePattern : this.getPatterns("Edge")) {
            ObservablePatternMatchSet<IPatternMatch> edgeSet = filter.getObservableSet(edgePattern, this.ruleEngine);
            this.resolver.setPriority(edgeSet.getSpecification(), 3);
            Annotation formatAnnotation = CorePatternLanguageHelper.getFirstAnnotationByName((Pattern)edgePattern, (String)"Format");
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)edgePattern, (String)"Edge")) {
                EdgeSet resultSet = new EdgeSet(annotation, formatAnnotation, itemMap, (IObservableSet)edgeSet);
                edgeSetsObservable.add(resultSet);
            }
        }
        FixedUnionSet Set2 = new FixedUnionSet(edgeSetsObservable.toArray(new IObservableSet[0]));
        return Set2;
    }

    public MultiList initializeObservableEdgeList(ViewerDataFilter filter, Multimap<Object, Item> itemMap) {
        ArrayList<EdgeList> edgeListsObservable = new ArrayList<EdgeList>();
        for (Pattern edgePattern : this.getPatterns("Edge")) {
            ObservablePatternMatchList<IPatternMatch> edgelist = filter.getObservableList(edgePattern, this.ruleEngine);
            this.resolver.setPriority(edgelist.getSpecification(), 3);
            Annotation formatAnnotation = CorePatternLanguageHelper.getFirstAnnotationByName((Pattern)edgePattern, (String)"Format");
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)edgePattern, (String)"Edge")) {
                EdgeList resultList = new EdgeList(annotation, formatAnnotation, itemMap, (IObservableList)edgelist);
                edgeListsObservable.add(resultList);
            }
        }
        MultiList list = new MultiList(edgeListsObservable.toArray(new IObservableList[edgeListsObservable.size()]));
        return list;
    }

    public IObservableSet initializeObservableContainmentSet(Multimap<Object, Item> itemMap) {
        return this.initializeObservableContainmentSet(ViewerDataFilter.UNFILTERED, itemMap);
    }

    public MultiList initializeObservableContainmentList(Multimap<Object, Item> itemMap) {
        return this.initializeObservableContainmentList(ViewerDataFilter.UNFILTERED, itemMap);
    }

    public IObservableSet initializeObservableContainmentSet(ViewerDataFilter filter, Multimap<Object, Item> itemMap) {
        HashSet<ContainmentSet> containmentSetsObservable = new HashSet<ContainmentSet>();
        for (Pattern containmentPattern : this.getPatterns("ContainsItem")) {
            ObservablePatternMatchSet<IPatternMatch> containmentSet = filter.getObservableSet(containmentPattern, this.ruleEngine);
            this.resolver.setPriority(containmentSet.getSpecification(), 2);
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)containmentPattern, (String)"ContainsItem")) {
                ContainmentSet resultSet = new ContainmentSet(annotation, itemMap, (IObservableSet)containmentSet);
                containmentSetsObservable.add(resultSet);
            }
        }
        FixedUnionSet Set2 = new FixedUnionSet(containmentSetsObservable.toArray(new IObservableSet[0]));
        return Set2;
    }

    public MultiList initializeObservableContainmentList(ViewerDataFilter filter, Multimap<Object, Item> itemMap) {
        ArrayList<ContainmentList> containmentListsObservable = new ArrayList<ContainmentList>();
        for (Pattern containmentPattern : this.getPatterns("ContainsItem")) {
            ObservablePatternMatchList<IPatternMatch> containmentList = filter.getObservableList(containmentPattern, this.ruleEngine);
            this.resolver.setPriority(containmentList.getSpecification(), 2);
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)containmentPattern, (String)"ContainsItem")) {
                ContainmentList resultList = new ContainmentList(annotation, itemMap, (IObservableList)containmentList);
                containmentListsObservable.add(resultList);
            }
        }
        MultiList list = new MultiList(containmentListsObservable.toArray(new IObservableList[containmentListsObservable.size()]));
        return list;
    }

    public void dispose() {
        if (this.ruleEngine != null) {
            this.ruleEngine.dispose();
        }
    }
}

