/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.job;

import com.google.common.base.Preconditions;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.Context;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.api.event.ActivationState;
import org.eclipse.incquery.runtime.evm.specific.job.EventAtomEditingDomainProvider;

public abstract class CommandExecutingJob<EventAtom>
extends Job<EventAtom> {
    public static final String COMMAND_EXECUTING_JOB_HELPER = "org.eclipse.incquery.evm.CommandExecutingJob.Helper";
    public static final String EDITING_DOMAIN = "org.eclipse.incquery.evm.CommandExecutingJob.EditingDomain";
    private final EventAtomEditingDomainProvider<EventAtom> provider;

    public CommandExecutingJob(ActivationState enablingState, EventAtomEditingDomainProvider<EventAtom> provider) {
        super(enablingState);
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (Object)"Provider cannot be null!");
        this.provider = provider;
    }

    protected void execute(Activation<? extends EventAtom> activation, Context context) {
        EditingDomain domain = this.findEditingDomain(activation, context);
        if (domain == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot find editing domain for activation ");
            sb.append(activation);
            sb.append(" and context ");
            sb.append(context);
            throw new IllegalStateException(sb.toString());
        }
        JobExecutionHelper executionHelper = new JobExecutionHelper(domain, activation, context);
        context.put(COMMAND_EXECUTING_JOB_HELPER, (Object)executionHelper);
        this.executeCommands(executionHelper);
        context.remove(COMMAND_EXECUTING_JOB_HELPER);
    }

    protected void handleError(Activation<? extends EventAtom> activation, Exception exception, Context context) {
        this.handleExecutableCommandError((JobExecutionHelper)context.remove(COMMAND_EXECUTING_JOB_HELPER), exception);
    }

    protected abstract void executeCommands(JobExecutionHelper var1);

    protected abstract void handleExecutableCommandError(JobExecutionHelper var1, Exception var2);

    protected EditingDomain findEditingDomain(Activation<? extends EventAtom> activation, Context context) {
        EditingDomain editingDomain = null;
        Object domainTarget = context.get(EDITING_DOMAIN);
        if (domainTarget instanceof EditingDomain) {
            editingDomain = (EditingDomain)domainTarget;
        }
        if (editingDomain == null && this.provider != null) {
            editingDomain = this.provider.findEditingDomain(activation, context);
        }
        return editingDomain;
    }

    public class JobExecutionHelper {
        public static final String COMMAND_EXECUTING_JOB_COMMAND = "org.eclipse.incquery.evm.CommandExecutingJob.Command";
        private final EditingDomain editingDomain;
        private final Activation<? extends EventAtom> activation;
        private final Context context;
        private final CompoundCommand compoundCommand;

        public JobExecutionHelper(EditingDomain domain, Activation<? extends EventAtom> activation, Context context) {
            this.editingDomain = domain;
            this.activation = activation;
            this.context = context;
            this.compoundCommand = new CompoundCommand(COMMAND_EXECUTING_JOB_COMMAND);
        }

        public EditingDomain getEditingDomain() {
            return this.editingDomain;
        }

        public Activation<? extends EventAtom> getActivation() {
            return this.activation;
        }

        public Context getContext() {
            return this.context;
        }

        public boolean appendAndExecuteSubCommand(Command subcommand) {
            return this.compoundCommand.appendAndExecute(subcommand);
        }
    }
}

