/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.context.surrogate;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;

public class SurrogateQueryRegistry {
    private Map<Object, String> registeredSurrogateQueryFQNMap = new WeakHashMap<Object, String>();
    private Map<Object, String> dynamicSurrogateQueryFQNMap = new WeakHashMap<Object, String>();
    private static final SurrogateQueryRegistry INSTANCE = new SurrogateQueryRegistry();

    private SurrogateQueryRegistry() {
    }

    public static SurrogateQueryRegistry instance() {
        return INSTANCE;
    }

    public String registerSurrogateQueryForFeature(Object feature, String surrogateQueryFQN) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        Preconditions.checkArgument((surrogateQueryFQN != null ? 1 : 0) != 0, (Object)"Surrogate query FQN must not be null!");
        return this.registeredSurrogateQueryFQNMap.put(feature, surrogateQueryFQN);
    }

    public String addDynamicSurrogateQueryForFeature(Object feature, String surrogateQueryFQN) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        Preconditions.checkArgument((surrogateQueryFQN != null ? 1 : 0) != 0, (Object)"Surrogate query FQN must not be null!");
        return this.dynamicSurrogateQueryFQNMap.put(feature, surrogateQueryFQN);
    }

    public String removeDynamicSurrogateQueryForFeature(Object feature) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        return this.dynamicSurrogateQueryFQNMap.remove(feature);
    }

    public boolean hasSurrogateQueryFQN(Object feature) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        boolean surrogateExists = this.dynamicSurrogateQueryFQNMap.containsKey(feature);
        if (!surrogateExists) {
            surrogateExists = this.registeredSurrogateQueryFQNMap.containsKey(feature);
        }
        return surrogateExists;
    }

    public String getSurrogateQueryFQN(Object feature) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        String surrogateFQN = this.dynamicSurrogateQueryFQNMap.get(feature);
        if (surrogateFQN == null) {
            surrogateFQN = this.registeredSurrogateQueryFQNMap.get(feature);
        }
        if (surrogateFQN != null) {
            return surrogateFQN;
        }
        throw new NoSuchElementException(String.format("Feature %s has no surrogate query defined! Use #hasSurrogateQueryFQN to check existence.", feature));
    }

    public Map<Object, String> getRegisteredSurrogateQueryFQNMap() {
        return this.registeredSurrogateQueryFQNMap;
    }

    public Map<Object, String> getDynamicSurrogateQueryFQNMap() {
        return this.dynamicSurrogateQueryFQNMap;
    }

    public Map<Object, String> getAllSurrogateQueryFQNMap() {
        HashMap allSurrogateQueries = Maps.newHashMap(this.registeredSurrogateQueryFQNMap);
        allSurrogateQueries.putAll(this.dynamicSurrogateQueryFQNMap);
        return allSurrogateQueries;
    }
}

